/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.casc.misc;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import hudson.ExtensionList;
import io.jenkins.plugins.casc.ConfigurationAsCode;
import io.jenkins.plugins.casc.ConfigurationContext;
import io.jenkins.plugins.casc.SchemaGeneration;
import io.jenkins.plugins.casc.core.JenkinsConfigurator;
import io.jenkins.plugins.casc.impl.configurators.GlobalConfigurationCategoryConfigurator;
import io.jenkins.plugins.casc.model.CNode;
import io.jenkins.plugins.casc.model.Mapping;
import io.jenkins.plugins.casc.snakeyaml.nodes.Node;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.GlobalConfigurationCategory;
import jenkins.tools.ToolConfigurationCategory;
import org.everit.json.schema.Schema;
import org.everit.json.schema.ValidationException;
import org.everit.json.schema.loader.SchemaLoader;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.junit.Assert;
import org.jvnet.hudson.test.LoggerRule;

public class Util {
    private static final Logger LOGGER = Logger.getLogger(Util.class.getName());
    private static final String failureMessage = "The YAML file provided for this schema is invalid";

    public static JenkinsConfigurator getJenkinsConfigurator() {
        return (JenkinsConfigurator)ExtensionList.lookup(JenkinsConfigurator.class).get(0);
    }

    public static Mapping getJenkinsRoot(ConfigurationContext context) throws Exception {
        JenkinsConfigurator root = Util.getJenkinsConfigurator();
        return Objects.requireNonNull(root.describe((Object)root.getTargetComponent(context), context)).asMapping();
    }

    public static Mapping getUnclassifiedRoot(ConfigurationContext context) throws Exception {
        GlobalConfigurationCategory.Unclassified unclassified = (GlobalConfigurationCategory.Unclassified)ExtensionList.lookup(GlobalConfigurationCategory.Unclassified.class).get(0);
        GlobalConfigurationCategoryConfigurator unclassifiedConfigurator = new GlobalConfigurationCategoryConfigurator((GlobalConfigurationCategory)unclassified);
        return Objects.requireNonNull(unclassifiedConfigurator.describe(unclassifiedConfigurator.getTargetComponent(context), context)).asMapping();
    }

    public static Mapping getSecurityRoot(ConfigurationContext context) throws Exception {
        GlobalConfigurationCategory.Security security = (GlobalConfigurationCategory.Security)ExtensionList.lookup(GlobalConfigurationCategory.Security.class).get(0);
        GlobalConfigurationCategoryConfigurator securityConfigurator = new GlobalConfigurationCategoryConfigurator((GlobalConfigurationCategory)security);
        return Objects.requireNonNull(securityConfigurator.describe(securityConfigurator.getTargetComponent(context), context)).asMapping();
    }

    public static Mapping getToolRoot(ConfigurationContext context) throws Exception {
        ToolConfigurationCategory category = (ToolConfigurationCategory)ExtensionList.lookup(ToolConfigurationCategory.class).get(0);
        GlobalConfigurationCategoryConfigurator configurator = new GlobalConfigurationCategoryConfigurator((GlobalConfigurationCategory)category);
        return Objects.requireNonNull(configurator.describe(configurator.getTargetComponent(context), context)).asMapping();
    }

    public static String toYamlString(CNode rootNode) throws IOException {
        Node yamlRoot = ConfigurationAsCode.get().toYaml(rootNode);
        StringWriter buffer = new StringWriter();
        ConfigurationAsCode.serializeYamlNode((Node)yamlRoot, (Writer)buffer);
        return buffer.toString();
    }

    public static String toStringFromYamlFile(Object clazz, String resourcePath) throws URISyntaxException {
        try {
            URL resource = clazz.getClass().getResource(resourcePath);
            if (resource == null) {
                throw new FileNotFoundException("Couldn't find file: " + resourcePath);
            }
            byte[] bytes = Files.readAllBytes(Paths.get(resource.toURI()));
            return new String(bytes, StandardCharsets.UTF_8).replaceAll("\r\n?", "\n");
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void assertNotInLog(LoggerRule logging, String unexpectedText) {
        Assert.assertFalse((String)("The log should not contain '" + unexpectedText + "'"), (boolean)logging.getMessages().stream().anyMatch(m -> m.contains(unexpectedText)));
    }

    public static void assertLogContains(LoggerRule logging, String expectedText) {
        Assert.assertTrue((String)("The log should contain '" + expectedText + "'"), (boolean)logging.getMessages().stream().anyMatch(m -> m.contains(expectedText)));
    }

    public static String convertToJson(String yamlString) {
        try {
            ObjectMapper yamlReader = new ObjectMapper((JsonFactory)new YAMLFactory());
            Object obj = yamlReader.readValue(yamlString, Object.class);
            ObjectMapper jsonWriter = new ObjectMapper();
            return jsonWriter.writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            throw new UncheckedIOException((IOException)((Object)e));
        }
    }

    public static Schema returnSchema() {
        JSONObject schemaObject = SchemaGeneration.generateSchema();
        JSONObject jsonSchema = new JSONObject(new JSONTokener(schemaObject.toString()));
        return SchemaLoader.load((JSONObject)jsonSchema);
    }

    public static List<String> validateSchema(JSONObject jsonSubject) {
        try {
            Util.returnSchema().validate((Object)jsonSubject);
        }
        catch (ValidationException e) {
            return e.getAllMessages();
        }
        catch (Exception ie) {
            LOGGER.log(Level.WARNING, failureMessage, ie);
            return Collections.singletonList("Exception during test" + ie.getMessage());
        }
        return Collections.emptyList();
    }

    public static JSONObject convertYamlFileToJson(Object clazz, String yamlFileName) throws URISyntaxException {
        String yamlStringContents = Util.toStringFromYamlFile(clazz, yamlFileName);
        return new JSONObject(new JSONTokener(Util.convertToJson(yamlStringContents)));
    }
}

