/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.casc;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import io.jenkins.plugins.casc.ConfigurationContext;
import io.jenkins.plugins.casc.FixedInterpolatorStringLookup;
import io.vavr.API;
import io.vavr.CheckedFunction0;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.Paths;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.text.StringSubstitutor;
import org.apache.commons.text.TextStringBuilder;
import org.apache.commons.text.lookup.StringLookup;
import org.json.JSONObject;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;

public class SecretSourceResolver {
    private static final String enclosedBy = "${";
    private static final String enclosedIn = "}";
    private static final char escapedWith = '^';
    private static final String escapeEnclosedBy = "^${";
    private static final Logger LOGGER = Logger.getLogger(SecretSourceResolver.class.getName());
    private final StringSubstitutor nullSubstitutor;
    private final StringSubstitutor substitutor;

    public SecretSourceResolver(ConfigurationContext configurationContext) {
        HashMap<String, StringLookup> map = new HashMap<String, Object>(8);
        map.put("base64", Base64Lookup.INSTANCE);
        map.put("fileBase64", FileBase64Lookup.INSTANCE);
        map.put("readFileBase64", FileBase64Lookup.INSTANCE);
        map.put("file", FileStringLookup.INSTANCE);
        map.put("readFile", FileStringLookup.INSTANCE);
        map.put("sysProp", SystemPropertyLookup.INSTANCE);
        map.put("decodeBase64", DecodeBase64Lookup.INSTANCE);
        map.put("json", JsonLookup.INSTANCE);
        map = Collections.unmodifiableMap(map);
        this.substitutor = new StringSubstitutor((StringLookup)new FixedInterpolatorStringLookup(map, new ConfigurationContextStringLookup(configurationContext))).setEscapeChar('^').setVariablePrefix(enclosedBy).setVariableSuffix(enclosedIn).setEnableSubstitutionInVariables(true).setPreserveEscapes(true);
        this.nullSubstitutor = new StringSubstitutor((StringLookup)UnresolvedLookup.INSTANCE).setEscapeChar('^').setVariablePrefix(enclosedBy).setVariableSuffix(enclosedIn);
    }

    public String encode(@CheckForNull String toEncode) {
        if (toEncode == null) {
            return null;
        }
        return toEncode.replace(enclosedBy, escapeEnclosedBy);
    }

    @Deprecated
    @Restricted(value={DoNotUse.class})
    public static String resolve(ConfigurationContext context, String toInterpolate) {
        return context.getSecretSourceResolver().resolve(toInterpolate);
    }

    public String resolve(String toInterpolate) {
        if (StringUtils.isBlank((String)toInterpolate) || !toInterpolate.contains(enclosedBy)) {
            return toInterpolate;
        }
        TextStringBuilder buf = new TextStringBuilder(toInterpolate);
        this.substitutor.replaceIn(buf);
        this.nullSubstitutor.replaceIn(buf);
        return buf.toString();
    }

    static class Base64Lookup
    implements StringLookup {
        static final Base64Lookup INSTANCE = new Base64Lookup();

        Base64Lookup() {
        }

        public String lookup(@NonNull String key) {
            return Base64.getEncoder().encodeToString(key.getBytes(StandardCharsets.UTF_8));
        }
    }

    static class FileBase64Lookup
    implements StringLookup {
        static final FileBase64Lookup INSTANCE = new FileBase64Lookup();

        FileBase64Lookup() {
        }

        public String lookup(@NonNull String key) {
            try {
                byte[] fileContent = Files.readAllBytes(Paths.get(key, new String[0]));
                return Base64.getEncoder().encodeToString(fileContent);
            }
            catch (IOException | InvalidPathException e) {
                LOGGER.log(Level.WARNING, String.format("Configuration import: Error looking up file '%s'. Will default to empty string", key), e);
                return null;
            }
        }
    }

    static class FileStringLookup
    implements StringLookup {
        static final FileStringLookup INSTANCE = new FileStringLookup();

        FileStringLookup() {
        }

        public String lookup(@NonNull String key) {
            try {
                return new String(Files.readAllBytes(Paths.get(key, new String[0])), StandardCharsets.UTF_8);
            }
            catch (IOException | InvalidPathException e) {
                LOGGER.log(Level.WARNING, String.format("Configuration import: Error looking up file '%s' with UTF-8 encoding. Will default to empty string", key), e);
                return null;
            }
        }
    }

    static class SystemPropertyLookup
    implements StringLookup {
        static final SystemPropertyLookup INSTANCE = new SystemPropertyLookup();

        SystemPropertyLookup() {
        }

        public String lookup(@NonNull String key) {
            String output = System.getProperty(key);
            if (output == null) {
                LOGGER.log(Level.WARNING, String.format("Configuration import: System Properties did not contain the specified key '%s'. Will default to empty string.", key));
                return "";
            }
            return output;
        }
    }

    static class DecodeBase64Lookup
    implements StringLookup {
        static final DecodeBase64Lookup INSTANCE = new DecodeBase64Lookup();

        DecodeBase64Lookup() {
        }

        public String lookup(@NonNull String key) {
            return new String(Base64.getDecoder().decode(key.getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
        }
    }

    static class JsonLookup
    implements StringLookup {
        static final JsonLookup INSTANCE = new JsonLookup();

        private JsonLookup() {
        }

        public String lookup(@NonNull String key) {
            String jsonFieldName;
            String[] components = key.split(":", 2);
            String json = components[1];
            JSONObject root = new JSONObject(json);
            String output = root.optString(jsonFieldName = components[0], null);
            if (output == null) {
                LOGGER.log(Level.WARNING, String.format("Configuration import: JSON secret did not contain the specified key '%s'. Will default to empty string.", jsonFieldName));
                return "";
            }
            return output;
        }
    }

    static class ConfigurationContextStringLookup
    implements StringLookup {
        private final ConfigurationContext context;

        private ConfigurationContextStringLookup(ConfigurationContext context) {
            this.context = context;
        }

        public String lookup(String key) {
            return this.context.getSecretSources().stream().map(source -> (Optional)API.unchecked((CheckedFunction0 & Serializable)() -> source.reveal(key)).apply()).flatMap(o -> o.map(Stream::of).orElseGet(Stream::empty)).findFirst().orElse(null);
        }
    }

    static class UnresolvedLookup
    implements StringLookup {
        static final UnresolvedLookup INSTANCE = new UnresolvedLookup();

        private UnresolvedLookup() {
        }

        public String lookup(String key) {
            LOGGER.log(Level.WARNING, String.format("Configuration import: Found unresolved variable '%s'. Will default to empty string", key));
            return "";
        }
    }
}

