/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.casc.yaml;

import hudson.ExtensionList;
import io.jenkins.plugins.casc.yaml.MergeStrategy;
import java.util.Optional;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;

public class MergeStrategyFactory {
    private static MergeStrategy getMergeStrategy(@Nonnull String name) {
        ExtensionList mergeStrategyList = Jenkins.get().getExtensionList(MergeStrategy.class);
        Optional<MergeStrategy> opt = mergeStrategyList.stream().filter(strategy -> strategy.getName().equals(name)).findFirst();
        return opt.orElse(null);
    }

    public static MergeStrategy getMergeStrategyOrDefault(String strategyName) {
        return MergeStrategyFactory.getMergeStrategy(StringUtils.isEmpty((String)strategyName) ? "errorOnConflict" : strategyName);
    }
}

