/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.casc.yaml;

import hudson.Extension;
import io.jenkins.plugins.casc.ConfiguratorException;
import io.jenkins.plugins.casc.yaml.MergeStrategy;
import io.jenkins.plugins.casc.yaml.OverrideMergeStrategy;
import java.util.Iterator;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.NodeId;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.ScalarNode;
import org.yaml.snakeyaml.nodes.SequenceNode;

@Extension
public class ErrorOnConflictMergeStrategy
implements MergeStrategy {
    @Override
    public void merge(Node root, Node node, String source) throws ConfiguratorException {
        if (root.getNodeId() != node.getNodeId()) {
            throw new ConfiguratorException(String.format("Found incompatible configuration elements %s %s", source, node.getStartMark()));
        }
        switch (root.getNodeId()) {
            case sequence: {
                SequenceNode seq = (SequenceNode)root;
                SequenceNode seq2 = (SequenceNode)node;
                seq.getValue().addAll(seq2.getValue());
                return;
            }
            case mapping: {
                MappingNode map = (MappingNode)root;
                MappingNode map2 = (MappingNode)node;
                Iterator it = map2.getValue().iterator();
                while (it.hasNext()) {
                    NodeTuple t2 = (NodeTuple)it.next();
                    for (NodeTuple tuple : map.getValue()) {
                        Node key = tuple.getKeyNode();
                        Node key2 = t2.getKeyNode();
                        if (key.getNodeId() == NodeId.scalar) {
                            if (!((ScalarNode)key).getValue().equals(((ScalarNode)key2).getValue())) continue;
                            this.merge(tuple.getValueNode(), t2.getValueNode(), source);
                            it.remove();
                            continue;
                        }
                        throw new ConfiguratorException(String.format("Found non-mergeable configuration keys %s %s)", source, node.getEndMark()));
                    }
                }
                map.getValue().addAll(map2.getValue());
                return;
            }
        }
        new OverrideMergeStrategy().merge(root, node, source);
    }

    @Override
    public String getName() {
        return "errorOnConflict";
    }
}

