/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.casc;

import com.google.common.base.Defaults;
import hudson.model.Descriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.PostConstruct;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.casc.Attribute;
import org.jenkinsci.plugins.casc.BaseConfigurator;
import org.jenkinsci.plugins.casc.Configurator;
import org.jenkinsci.plugins.casc.ConfiguratorException;
import org.jenkinsci.plugins.casc.DescribableAttribute;
import org.jenkinsci.plugins.casc.model.CNode;
import org.jenkinsci.plugins.casc.model.Mapping;
import org.kohsuke.stapler.ClassDescriptor;

public class DataBoundConfigurator<T>
extends BaseConfigurator<T> {
    private static final Logger logger = Logger.getLogger(DataBoundConfigurator.class.getName());
    private final Class target;

    public DataBoundConfigurator(Class<T> clazz) {
        this.target = clazz;
    }

    @Override
    public Class getTarget() {
        return this.target;
    }

    @Override
    public T configure(CNode c) throws ConfiguratorException {
        Object object;
        Mapping config = c != null ? c.asMapping() : Mapping.EMPTY;
        Constructor constructor = this.getDataBoundConstructor();
        Parameter[] parameters = constructor.getParameters();
        String[] names = ClassDescriptor.loadParameterNames((Constructor)constructor);
        Object[] args = new Object[names.length];
        if (parameters.length > 0) {
            for (int i = 0; i < names.length; ++i) {
                CNode value = (CNode)config.remove(names[i]);
                if (value == null && parameters[i].getAnnotation(Nonnull.class) != null) {
                    throw new IllegalArgumentException(names[i] + " is required to configure " + this.target);
                }
                Class<?> t = parameters[i].getType();
                if (value != null) {
                    if (Collection.class.isAssignableFrom(t)) {
                        Type type = parameters[i].getParameterizedType();
                        Configurator lookup = Configurator.lookup(type);
                        ArrayList list = new ArrayList();
                        for (CNode o : value.asSequence()) {
                            list.add(lookup.configure(o));
                        }
                        args[i] = list;
                    } else {
                        Class<?> clazz = parameters[i].getParameterizedType();
                        Class<?> k = clazz != null ? clazz : t;
                        Configurator configurator = Configurator.lookup(k);
                        if (configurator == null) {
                            throw new IllegalStateException("No configurator implementation to manage " + k);
                        }
                        args[i] = configurator.configure(value);
                    }
                    logger.info("Setting " + this.target + "." + names[i] + " = " + value);
                    continue;
                }
                if (!t.isPrimitive()) continue;
                args[i] = Defaults.defaultValue(t);
            }
        }
        try {
            object = constructor.newInstance(args);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException ex) {
            ArrayList<String> argumentTypes = new ArrayList<String>(args.length);
            for (Object arg : args) {
                argumentTypes.add(arg != null ? arg.getClass().getName() : "null");
            }
            throw new ConfiguratorException(this, "Failed to construct instance of " + this.target + ".\n Constructor: " + constructor.toString() + ".\n Arguments: " + argumentTypes, ex);
        }
        Set<Attribute> attributes = this.describe();
        for (Attribute attribute : attributes) {
            Object value;
            String name = attribute.getName();
            Configurator lookup = Configurator.lookup(attribute.getType());
            if (!config.containsKey(name)) continue;
            CNode yaml = (CNode)config.get(name);
            if (attribute.isMultiple()) {
                ArrayList l = new ArrayList();
                for (CNode o : yaml.asSequence()) {
                    l.add(lookup.configure(o));
                }
                value = l;
            } else {
                value = lookup.configure((CNode)config.get(name));
            }
            try {
                logger.info("Setting " + object + '.' + name + " = " + (yaml.isSensitiveData() ? "****" : value));
                attribute.setValue(object, value);
            }
            catch (Exception e) {
                throw new ConfiguratorException(this, "Failed to set attribute " + attribute, e);
            }
        }
        for (Method method : this.target.getMethods()) {
            if (method.getParameterCount() != 0 || method.getAnnotation(PostConstruct.class) == null) continue;
            try {
                method.invoke(object, null);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new ConfiguratorException(this, "Failed to invoke configurator method " + method, e);
            }
        }
        return object;
    }

    @Override
    public String getName() {
        Descriptor d = this.getDescriptor();
        return DescribableAttribute.getSymbolName(d, this.getExtensionPoint(), this.getTarget());
    }

    private Descriptor getDescriptor() {
        return Jenkins.getInstance().getDescriptor(this.getTarget());
    }

    @Override
    public Class getExtensionPoint() {
        Type superclass;
        Descriptor descriptor = this.getDescriptor();
        if (descriptor != null && (superclass = descriptor.getClass().getGenericSuperclass()) instanceof ParameterizedType) {
            ParameterizedType genericSuperclass = (ParameterizedType)superclass;
            Type type = genericSuperclass.getActualTypeArguments()[0];
            if (type instanceof ParameterizedType) {
                type = ((ParameterizedType)type).getRawType();
            }
            if (type instanceof Class) {
                return (Class)type;
            }
        }
        return super.getExtensionPoint();
    }

    @Override
    public Set<Attribute> describe() {
        Set<Attribute> attributes = super.describe();
        Constructor constructor = DataBoundConfigurator.getDataBoundConstructor(this.target);
        if (constructor != null) {
            Parameter[] parameters = constructor.getParameters();
            String[] names = ClassDescriptor.loadParameterNames((Constructor)constructor);
            for (int i = 0; i < parameters.length; ++i) {
                Parameter p = parameters[i];
                Attribute a = this.detectActualType(names[i], p.getParameterizedType());
                if (a == null) continue;
                attributes.add(a);
            }
        }
        return attributes;
    }

    @Override
    @CheckForNull
    public CNode describe(T instance) throws Exception {
        Constructor constructor = this.getDataBoundConstructor();
        Parameter[] parameters = constructor.getParameters();
        String[] names = ClassDescriptor.loadParameterNames((Constructor)constructor);
        Attribute[] attributes = new Attribute[parameters.length];
        Object[] args = new Object[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            Parameter p = parameters[i];
            Attribute a = this.detectActualType(names[i], p.getParameterizedType());
            args[i] = a.getValue(instance);
            attributes[i] = a;
        }
        Object ref = constructor.newInstance(args);
        Mapping mapping = this.compare(instance, ref);
        for (int i = 0; i < parameters.length; ++i) {
            Configurator c = Configurator.lookup(attributes[i].getType());
            if (args[i] == null) continue;
            mapping.put(names[i], attributes[i].describe(instance));
        }
        return mapping;
    }

    private Constructor getDataBoundConstructor() {
        Constructor constructor = DataBoundConfigurator.getDataBoundConstructor(this.target);
        if (constructor == null) {
            throw new IllegalStateException(this.target.getName() + " is missing a @DataBoundConstructor");
        }
        return constructor;
    }

    @Override
    public String getDisplayName() {
        Descriptor descriptor = this.getDescriptor();
        return descriptor != null ? descriptor.getDisplayName() : "";
    }
}

