/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.casc;

import hudson.model.Describable;
import java.beans.PropertyDescriptor;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.casc.Attribute;
import org.jenkinsci.plugins.casc.Configurator;
import org.jenkinsci.plugins.casc.ConfiguratorException;
import org.jenkinsci.plugins.casc.DescribableAttribute;
import org.jenkinsci.plugins.casc.model.CNode;
import org.jenkinsci.plugins.casc.model.Mapping;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.stapler.export.Exported;

public abstract class BaseConfigurator<T>
extends Configurator<T> {
    private static final Logger LOGGER = Logger.getLogger(BaseConfigurator.class.getName());

    @Override
    public Set<Attribute> describe() {
        HashSet<Attribute> attributes = new HashSet<Attribute>();
        Class target = this.getTarget();
        PropertyDescriptor[] properties = PropertyUtils.getPropertyDescriptors(target);
        LOGGER.log(Level.FINE, "Found {0} properties for {1}", new Object[]{properties.length, target});
        for (PropertyDescriptor p : properties) {
            Symbol s;
            Exported annotation;
            String name = p.getName();
            LOGGER.log(Level.FINER, "Processing {0} property", name);
            Method setter = p.getWriteMethod();
            if (setter == null) {
                LOGGER.log(Level.FINE, "Ignored {0} property: read only", name);
                continue;
            }
            if (setter.getAnnotation(Deprecated.class) != null) {
                LOGGER.log(Level.FINE, "Ignored {0} property: deprecated", name);
                continue;
            }
            if (setter.getAnnotation(Restricted.class) != null) {
                LOGGER.log(Level.FINE, "Ignored {0} property: restricted", name);
                continue;
            }
            Type type = setter.getGenericParameterTypes()[0];
            Attribute attribute = this.detectActualType(name, type);
            if (attribute == null) continue;
            attributes.add(attribute);
            Method getter = p.getReadMethod();
            if (getter != null && (annotation = getter.getAnnotation(Exported.class)) != null && StringUtils.isNotBlank((String)annotation.name())) {
                attribute.preferredName(annotation.name());
            }
            if ((s = setter.getAnnotation(Symbol.class)) == null) continue;
            attribute.preferredName(s.value()[0]);
        }
        return attributes;
    }

    protected Attribute detectActualType(String name, Type type) {
        Attribute attribute;
        Class c = null;
        boolean multiple = false;
        if (type instanceof GenericArrayType) {
            multiple = true;
            GenericArrayType at = (GenericArrayType)type;
            type = at.getGenericComponentType();
        }
        while (type instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)type;
            Class rawType = (Class)pt.getRawType();
            if (Collection.class.isAssignableFrom(rawType)) {
                multiple = true;
            }
            if (!((type = pt.getActualTypeArguments()[0]) instanceof WildcardType)) continue;
            Type t = ((WildcardType)type).getUpperBounds()[0];
            if (t == Object.class) {
                type = pt.getRawType();
                continue;
            }
            type = t;
        }
        if (type instanceof ParameterizedType) {
            Type[] arguments = ((ParameterizedType)type).getActualTypeArguments();
            type = ((ParameterizedType)type).getRawType();
        }
        while (c == null) {
            if (type instanceof Class) {
                c = (Class)type;
                continue;
            }
            if (type instanceof TypeVariable) {
                Type superclass = this.getTarget().getGenericSuperclass();
                if (superclass instanceof ParameterizedType) {
                    ParameterizedType psc = (ParameterizedType)superclass;
                    type = psc.getActualTypeArguments()[0];
                    continue;
                }
                c = (Class)((TypeVariable)type).getBounds()[0];
                TypeVariable typeVariable = (TypeVariable)type;
                continue;
            }
            throw new IllegalStateException("Unable to detect type of attribute " + this.getTarget() + '#' + name);
        }
        if (c.isArray()) {
            multiple = true;
            c = c.getComponentType();
        }
        if (!c.isPrimitive() && !c.isEnum() && Modifier.isAbstract(c.getModifiers())) {
            if (!Describable.class.isAssignableFrom(c)) {
                return null;
            }
            attribute = new DescribableAttribute(name, (Class<? extends Describable>)c);
        } else {
            attribute = new Attribute(name, c);
        }
        attribute.multiple(multiple);
        return attribute;
    }

    protected void configure(Mapping config, T instance) throws ConfiguratorException {
        Set<Attribute> attributes = this.describe();
        for (Attribute attribute : attributes) {
            Object valueToSet;
            String name = attribute.getName();
            CNode sub = this.removeIgnoreCase(config, name);
            if (sub == null) continue;
            Class k = attribute.getType();
            Configurator configurator = Configurator.lookupOrFail(k);
            if (attribute.isMultiple()) {
                ArrayList values = new ArrayList();
                for (CNode o : sub.asSequence()) {
                    Object value = configurator.configure(o);
                    values.add(value);
                }
                valueToSet = values;
            } else {
                valueToSet = configurator.configure(sub);
            }
            try {
                attribute.setValue(instance, valueToSet);
            }
            catch (Exception ex) {
                throw new ConfiguratorException(configurator, "Failed to set attribute " + attribute, ex);
            }
        }
        if (!config.isEmpty()) {
            String invalid = StringUtils.join(config.keySet(), (char)',');
            throw new ConfiguratorException("Invalid configuration elements for type " + instance.getClass() + " : " + invalid);
        }
    }

    protected Mapping compare(T o1, T o2) throws Exception {
        Mapping mapping = new Mapping();
        for (Attribute attribute : this.describe()) {
            if (attribute.equals(o1, o2)) continue;
            mapping.put(attribute.getName(), attribute.describe(o1));
        }
        return mapping;
    }

    private CNode removeIgnoreCase(Mapping config, String name) {
        for (String k : config.keySet()) {
            if (!name.equalsIgnoreCase(k)) continue;
            return (CNode)config.remove(k);
        }
        return null;
    }
}

