/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.casc;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.commons.beanutils.PropertyUtils;
import org.jenkinsci.plugins.casc.Configurator;
import org.jenkinsci.plugins.casc.model.CNode;
import org.jenkinsci.plugins.casc.model.Sequence;

public class Attribute<Owner, Type> {
    private static final Logger logger = Logger.getLogger(Attribute.class.getName());
    protected final String name;
    protected final Class type;
    protected boolean multiple;
    protected String preferredName;
    private Setter<Owner, Type> setter;
    private Getter<Owner, Type> getter;
    public static final Setter NOOP = (target, value) -> {};

    public Attribute(String name, Class type) {
        this.name = name;
        this.type = type;
        this.getter = this::_getValue;
        this.setter = this::_setValue;
    }

    public String toString() {
        return String.format("%s(class: %s, multiple: %s)", this.name, this.type, this.multiple);
    }

    public String getName() {
        return this.preferredName != null ? this.preferredName : this.name;
    }

    public Class getType() {
        return this.type;
    }

    public boolean isMultiple() {
        return this.multiple;
    }

    public Attribute<Owner, Type> multiple(boolean multiple) {
        this.multiple = multiple;
        return this;
    }

    public Attribute<Owner, Type> preferredName(String preferredName) {
        this.preferredName = preferredName;
        return this;
    }

    public Attribute<Owner, Type> setter(Setter<Owner, Type> setter) {
        this.setter = setter;
        return this;
    }

    public Attribute<Owner, Type> getter(Getter<Owner, Type> getter) {
        this.getter = getter;
        return this;
    }

    public Setter<Owner, Type> getSetter() {
        return this.setter;
    }

    public Getter<Owner, Type> getGetter() {
        return this.getter;
    }

    public List<String> possibleValues() {
        if (this.type.isEnum()) {
            Class e = this.type;
            return Arrays.stream(e.getEnumConstants()).map(Enum::name).collect(Collectors.toList());
        }
        return Collections.EMPTY_LIST;
    }

    public void setValue(Owner target, Type value) throws Exception {
        this.setter.setValue(target, value);
    }

    public Type getValue(Owner target) throws Exception {
        return this.getter.getValue(target);
    }

    public CNode describe(Owner instance) throws Exception {
        Configurator c = Configurator.lookupOrFail(this.type);
        Type o = this.getValue(instance);
        if (o == null) {
            return null;
        }
        if (this.multiple) {
            Sequence seq = new Sequence();
            for (Object value : (Iterable)o) {
                seq.add(c.describe(value));
            }
            return seq;
        }
        return c.describe(o);
    }

    public boolean equals(Owner o1, Owner o2) throws Exception {
        Type v1 = this.getValue(o1);
        Type v2 = this.getValue(o2);
        if (v1 == null && v2 == null) {
            return true;
        }
        return v1 != null && v1.equals(v2);
    }

    private Type _getValue(Owner target) throws Exception {
        PropertyDescriptor property = PropertyUtils.getPropertyDescriptor(target, (String)this.name);
        if (property == null) {
            return null;
        }
        Method readMethod = property.getReadMethod();
        if (readMethod == null) {
            return null;
        }
        return (Type)readMethod.invoke(target, new Object[0]);
    }

    private void _setValue(Owner target, Type value) throws Exception {
        String setterId = target.getClass().getCanonicalName() + '#' + this.name;
        logger.info("Setting " + setterId + " = " + value);
        PropertyDescriptor property = PropertyUtils.getPropertyDescriptor(target, (String)this.name);
        if (property == null) {
            throw new Exception("Default value setter cannot find Property Descriptor for " + setterId);
        }
        Method writeMethod = property.getWriteMethod();
        Object o = value;
        if (this.multiple) {
            if (!(value instanceof Collection)) {
                throw new IllegalArgumentException(setterId + " should be a list.");
            }
            Class<Set> c = writeMethod.getParameterTypes()[0];
            if (c.isArray()) {
                Collection collection = (Collection)value;
                o = collection.toArray((Object[])Array.newInstance(this.type, collection.size()));
            } else if (c.isAssignableFrom(Set.class)) {
                o = new HashSet((Collection)value);
            }
        }
        writeMethod.invoke(target, o);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Attribute attribute = (Attribute)o;
        return Objects.equals(this.name, attribute.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    @FunctionalInterface
    public static interface Getter<O, T> {
        public T getValue(O var1) throws Exception;
    }

    @FunctionalInterface
    public static interface Setter<O, T> {
        public void setValue(O var1, T var2) throws Exception;
    }
}

