/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.casc.impl.secrets;

import com.bettercloud.vault.Vault;
import com.bettercloud.vault.VaultConfig;
import com.bettercloud.vault.VaultException;
import hudson.Extension;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jenkinsci.plugins.casc.SecretSource;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.Beta;

@Extension
@Restricted(value={Beta.class})
public class VaultSecretSource
extends SecretSource {
    private static final Logger LOGGER = Logger.getLogger(VaultSecretSource.class.getName());
    private Map<String, String> secrets = new HashMap<String, String>();

    public VaultSecretSource() {
        String vaultFile = System.getenv("CASC_VAULT_FILE");
        Properties prop = new Properties();
        if (vaultFile != null) {
            try (FileInputStream input = new FileInputStream(vaultFile);){
                prop.load(input);
                if (prop.isEmpty()) {
                    LOGGER.log(Level.WARNING, "Vault secret file is empty");
                }
            }
            catch (IOException ex) {
                LOGGER.log(Level.WARNING, "Failed to load Vault secrets from file", ex);
            }
        }
        String vaultPw = this.getVariable("CASC_VAULT_PW", prop);
        String vaultUsr = this.getVariable("CASC_VAULT_USER", prop);
        String vaultPth = this.getVariable("CASC_VAULT_PATH", prop);
        String vaultUrl = this.getVariable("CASC_VAULT_URL", prop);
        String vaultMount = this.getVariable("CASC_VAULT_MOUNT", prop);
        String vaultToken = this.getVariable("CASC_VAULT_TOKEN", prop);
        if ((vaultPw != null && vaultUsr != null || vaultToken != null) && vaultPth != null && vaultUrl != null) {
            LOGGER.log(Level.FINE, "Attempting to connect to Vault: {0}", vaultUrl);
            try {
                String token;
                VaultConfig config = new VaultConfig().address(vaultUrl).build();
                Vault vault = new Vault(config);
                if (vaultToken != null) {
                    token = vaultToken;
                    LOGGER.log(Level.FINE, "Using supplied token to access Vault");
                } else {
                    token = vault.auth().loginByUserPass(vaultUsr, vaultPw, vaultMount).getAuthClientToken();
                    LOGGER.log(Level.FINE, "Login to Vault using U/P successful");
                }
                config.token(token).build();
                this.secrets = vault.logical().read(vaultPth).getData();
            }
            catch (VaultException ve) {
                LOGGER.log(Level.WARNING, "Unable to connect to Vault", ve);
            }
        }
    }

    @Override
    public Optional<String> reveal(String vaultKey) {
        Optional<String> returnValue = Optional.empty();
        if (this.secrets.containsKey(vaultKey)) {
            returnValue = Optional.of(this.secrets.get(vaultKey));
        }
        return returnValue;
    }

    public Map<String, String> getSecrets() {
        return this.secrets;
    }

    public void setSecrets(Map<String, String> secrets) {
        this.secrets = secrets;
    }

    private String getVariable(String key, Properties prop) {
        if (prop != null && !prop.isEmpty()) {
            return prop.getProperty(key, System.getenv(key));
        }
        return System.getenv(key);
    }
}

