/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.casc.model;

import java.io.IOException;
import java.util.Optional;
import java.util.stream.IntStream;
import org.jenkinsci.plugins.casc.SecretSource;
import org.jenkinsci.plugins.casc.model.CNode;
import org.jenkinsci.plugins.casc.model.Source;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.Beta;
import org.yaml.snakeyaml.nodes.Tag;

@Restricted(value={Beta.class})
public final class Scalar
implements CNode,
CharSequence {
    private String value;
    private Tag tag;
    private boolean raw;
    private Source source;

    public Scalar(String value, Source source) {
        this(value);
        this.source = source;
    }

    public Scalar(String value) {
        this.value = value;
        this.tag = Tag.STR;
        this.raw = false;
    }

    public Scalar(Enum instance) {
        this.value = instance.name();
        this.tag = Tag.STR;
        this.raw = true;
    }

    public Scalar(Boolean instance) {
        this.value = String.valueOf(instance);
        this.tag = Tag.BOOL;
        this.raw = true;
    }

    public Scalar(Number instance) {
        this.value = String.valueOf(instance);
        this.tag = Tag.INT;
        this.raw = true;
    }

    @Override
    public CNode.Type getType() {
        return CNode.Type.SCALAR;
    }

    public Tag getTag() {
        return this.tag;
    }

    public boolean isRaw() {
        return this.raw;
    }

    @Override
    public Scalar asScalar() {
        return this;
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public boolean isSensitiveData() {
        return SecretSource.requiresReveal(this.value).isPresent();
    }

    @Override
    public String toString() {
        String s = this.value;
        Optional<String> r = SecretSource.requiresReveal(this.value);
        if (r.isPresent()) {
            Optional<String> defaultValue;
            Optional<Object> reveal = Optional.empty();
            for (SecretSource secretSource : SecretSource.all()) {
                try {
                    reveal = secretSource.reveal(r.get());
                }
                catch (IOException ex) {
                    throw new RuntimeException("Cannot reveal secret source for variable with key: " + s, ex);
                }
                if (!reveal.isPresent()) continue;
                s = (String)reveal.get();
                break;
            }
            if ((defaultValue = SecretSource.defaultValue(this.value)).isPresent() && !reveal.isPresent()) {
                s = defaultValue.get();
            }
            if (!reveal.isPresent() && !defaultValue.isPresent()) {
                throw new RuntimeException("Unable to reveal variable with key: " + s);
            }
        }
        return s;
    }

    @Override
    public IntStream chars() {
        return this.value.chars();
    }

    @Override
    public IntStream codePoints() {
        return this.value.codePoints();
    }

    @Override
    public int length() {
        return this.value.length();
    }

    @Override
    public char charAt(int index) {
        return this.value.charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.value.subSequence(start, end);
    }

    @Override
    public Source getSource() {
        return this.source;
    }
}

