/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.casc.integrations.jobdsl;

import hudson.EnvVars;
import hudson.Extension;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javaposse.jobdsl.dsl.GeneratedItems;
import javaposse.jobdsl.dsl.JobManagement;
import javaposse.jobdsl.plugin.JenkinsDslScriptLoader;
import javaposse.jobdsl.plugin.JenkinsJobManagement;
import javaposse.jobdsl.plugin.LookupStrategy;
import javax.annotation.CheckForNull;
import org.jenkinsci.plugins.casc.Attribute;
import org.jenkinsci.plugins.casc.ConfiguratorException;
import org.jenkinsci.plugins.casc.RootElementConfigurator;
import org.jenkinsci.plugins.casc.model.CNode;
import org.jenkinsci.plugins.casc.model.Sequence;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Extension(optional=true)
@Restricted(value={NoExternalUse.class})
public class SeedJobConfigurator
implements RootElementConfigurator<List<GeneratedItems>> {
    @Override
    public String getName() {
        return "jobs";
    }

    @Override
    public Set<Attribute> describe() {
        return Collections.EMPTY_SET;
    }

    @Override
    public List<GeneratedItems> getTargetComponent() {
        return Collections.EMPTY_LIST;
    }

    @Override
    public List<GeneratedItems> configure(CNode config) throws ConfiguratorException {
        JenkinsJobManagement mng = new JenkinsJobManagement(System.out, (Map)new EnvVars(), null, null, LookupStrategy.JENKINS_ROOT);
        Sequence scripts = config.asSequence();
        ArrayList<GeneratedItems> generated = new ArrayList<GeneratedItems>();
        for (CNode script : scripts) {
            try {
                generated.add(new JenkinsDslScriptLoader((JobManagement)mng).runScript(script.asScalar().getValue()));
            }
            catch (Exception ex) {
                throw new ConfiguratorException(this, "Failed to execute script with hash " + script.hashCode(), ex);
            }
        }
        return generated;
    }

    @Override
    public List<GeneratedItems> check(CNode config) throws ConfiguratorException {
        return Collections.emptyList();
    }

    @Override
    @CheckForNull
    public CNode describe(List<GeneratedItems> instance) {
        return null;
    }
}

