/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.service.embedded.rest;

import hudson.Extension;
import hudson.model.FreeStyleBuild;
import hudson.model.FreeStyleProject;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.Run;
import io.jenkins.blueocean.rest.Reachable;
import io.jenkins.blueocean.rest.annotation.Capability;
import io.jenkins.blueocean.rest.factory.BluePipelineFactory;
import io.jenkins.blueocean.rest.model.BlueOrganization;
import io.jenkins.blueocean.rest.model.BluePipeline;
import io.jenkins.blueocean.rest.model.BlueRun;
import io.jenkins.blueocean.rest.model.Resource;
import io.jenkins.blueocean.service.embedded.rest.AbstractBlueRunSummary;
import io.jenkins.blueocean.service.embedded.rest.AbstractPipelineImpl;
import io.jenkins.blueocean.service.embedded.rest.FreeStyleRunImpl;

@Capability(value={"hudson.model.FreeStyleProject"})
public class FreeStylePipeline
extends AbstractPipelineImpl {
    private final Job job;

    private FreeStylePipeline(BlueOrganization organization, Job job) {
        super(organization, job);
        this.job = job;
    }

    @Override
    public BlueRun getLatestRun() {
        Run run = this.job.getLastBuild();
        if (run instanceof FreeStyleBuild) {
            FreeStyleRunImpl blueRun = new FreeStyleRunImpl((FreeStyleBuild)run, (Reachable)this, this.organization);
            return new FreeStyleRunSummary(blueRun, run, (Reachable)this, this.organization);
        }
        return super.getLatestRun();
    }

    @Extension(ordinal=1.0)
    public static class FactoryImpl
    extends BluePipelineFactory {
        public BluePipeline getPipeline(Item item, Reachable parent, BlueOrganization organization) {
            if (item instanceof FreeStyleProject) {
                FreeStyleProject job = (FreeStyleProject)item;
                return new FreeStylePipeline(organization, (Job)job);
            }
            return null;
        }

        public Resource resolve(Item context, Reachable parent, Item target, BlueOrganization organization) {
            if (context == target && target instanceof FreeStyleProject) {
                return this.getPipeline(target, parent, organization);
            }
            return null;
        }
    }

    @Capability(value={"hudson.model.FreeStyleBuild"})
    static class FreeStyleRunSummary
    extends AbstractBlueRunSummary {
        public FreeStyleRunSummary(BlueRun blueRun, Run run, Reachable parent, BlueOrganization organization) {
            super(blueRun, run, parent, organization);
        }
    }
}

