/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.service.embedded.rest;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import hudson.model.BuildableItem;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.Queue;
import hudson.model.Run;
import io.jenkins.blueocean.commons.ServiceException;
import io.jenkins.blueocean.rest.factory.BluePipelineFactory;
import io.jenkins.blueocean.rest.hal.Link;
import io.jenkins.blueocean.rest.model.BlueOrganization;
import io.jenkins.blueocean.rest.model.BluePipeline;
import io.jenkins.blueocean.rest.model.BlueQueueItem;
import io.jenkins.blueocean.service.embedded.rest.QueueItemImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import jenkins.model.Jenkins;

public class QueueUtil {
    public static BlueQueueItem getQueuedItem(BlueOrganization organization, Queue.Item item, Job job) {
        for (BlueQueueItem qi : QueueUtil.getQueuedItems(organization, job)) {
            if (qi.getId() == null || !qi.getId().equalsIgnoreCase(Long.toString(item.getId()))) continue;
            return qi;
        }
        return null;
    }

    @Nullable
    public static <T extends Run> T getRun(@Nonnull Job job, long queueId) {
        try {
            return (T)((Run)Iterables.find((Iterable)job.getBuilds(), input -> input != null && input.getQueueId() == queueId));
        }
        catch (NoSuchElementException noSuchElementException) {
            return null;
        }
    }

    public static List<BlueQueueItem> getQueuedItems(BlueOrganization organization, Job job) {
        BluePipeline pipeline = (BluePipeline)BluePipelineFactory.resolve((Item)job);
        if (job instanceof BuildableItem && pipeline != null) {
            BuildableItem task = (BuildableItem)job;
            List items = Jenkins.getInstance().getQueue().getItems((Queue.Task)task);
            ArrayList items2 = Lists.newArrayList();
            for (int i = 0; i < items.size(); ++i) {
                Link self = pipeline.getLink().rel("queue").rel(Long.toString(((Queue.Item)items.get(i)).getId()));
                QueueItemImpl queueItem = new QueueItemImpl(organization, (Queue.Item)items.get(i), pipeline, items.size() == 1 ? job.getNextBuildNumber() : job.getNextBuildNumber() + i, self, pipeline.getLink());
                items2.add(0, queueItem);
            }
            return items2;
        }
        throw new ServiceException.UnexpectedErrorException("This pipeline is not buildable and therefore does not have a queue.");
    }

    private QueueUtil() {
    }
}

