/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.service.embedded.rest;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import hudson.model.Run;
import io.jenkins.blueocean.commons.ServiceException;
import io.jenkins.blueocean.rest.Reachable;
import io.jenkins.blueocean.rest.factory.BlueTestResultFactory;
import io.jenkins.blueocean.rest.model.BlueTestResult;
import io.jenkins.blueocean.rest.model.BlueTestResultContainer;
import java.util.Iterator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;

public class BlueTestResultContainerImpl
extends BlueTestResultContainer {
    protected final Run<?, ?> run;

    public BlueTestResultContainerImpl(Reachable parent, Run<?, ?> run) {
        super(parent);
        this.run = run;
    }

    protected BlueTestResultFactory.Result resolve() {
        return BlueTestResultFactory.resolve(this.run, (Reachable)this.parent);
    }

    public BlueTestResult get(String name) {
        BlueTestResultFactory.Result resolved = this.resolve();
        if (resolved.summary == null || resolved.results == null) {
            throw new ServiceException.NotFoundException("no tests");
        }
        BlueTestResult testResult = (BlueTestResult)Iterables.find((Iterable)resolved.results, input -> input != null && input.getId().equals(name), null);
        if (testResult == null) {
            throw new ServiceException.NotFoundException("not found");
        }
        return testResult;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nonnull
    public Iterator<BlueTestResult> iterator() {
        void var3_10;
        BlueTestResultFactory.Result resolved = this.resolve();
        if (resolved.summary == null || resolved.results == null) {
            throw new ServiceException.NotFoundException("no tests");
        }
        StaplerRequest request = Stapler.getCurrentRequest();
        if (request != null) {
            String status = request.getParameter("status");
            String state = request.getParameter("state");
            if (StringUtils.isEmpty((String)status) && StringUtils.isEmpty((String)state)) {
                Iterator iterator = resolved.results.iterator();
                return var3_10;
            } else if (!StringUtils.isEmpty((String)status)) {
                Iterator<BlueTestResult> iterator = BlueTestResultContainerImpl.filterByStatus(resolved.results, status);
                return var3_10;
            } else {
                if (StringUtils.isEmpty((String)state)) throw new ServiceException.BadRequestException("must provide either 'status' or 'state' params");
                Iterator<BlueTestResult> iterator = BlueTestResultContainerImpl.filterByState(resolved.results, state);
            }
            return var3_10;
        } else {
            Iterator iterator = resolved.results.iterator();
        }
        return var3_10;
    }

    @VisibleForTesting
    public static Iterator<BlueTestResult> filterByStatus(Iterable<BlueTestResult> results, String status) {
        String[] statusAtoms = StringUtils.split((String)status, (char)',');
        Predicate predicate = Predicates.alwaysFalse();
        if (statusAtoms == null || statusAtoms.length == 0) {
            throw new ServiceException.BadRequestException("status not provided");
        }
        for (String statusString : statusAtoms) {
            BlueTestResult.Status queryStatus;
            try {
                queryStatus = BlueTestResult.Status.valueOf((String)statusString.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                throw new ServiceException.BadRequestException("bad status " + status, (Throwable)e);
            }
            predicate = Predicates.or((Predicate)predicate, (Predicate)new StatusPredicate(queryStatus));
        }
        return Iterables.filter(results, (Predicate)predicate).iterator();
    }

    @VisibleForTesting
    public static Iterator<BlueTestResult> filterByState(Iterable<BlueTestResult> results, String state) {
        String[] stateAtoms = StringUtils.split((String)state, (char)',');
        Predicate predicate = Predicates.alwaysFalse();
        if (stateAtoms == null || stateAtoms.length == 0) {
            throw new ServiceException.BadRequestException("state not provided");
        }
        for (String stateString : stateAtoms) {
            BlueTestResult.State queryState;
            try {
                queryState = BlueTestResult.State.valueOf((String)stateString.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                throw new ServiceException.BadRequestException("bad state " + state, (Throwable)e);
            }
            predicate = Predicates.or((Predicate)predicate, (Predicate)new StatePredicate(queryState));
        }
        return Iterables.filter(results, (Predicate)predicate).iterator();
    }

    static class StatePredicate
    implements Predicate<BlueTestResult> {
        private final BlueTestResult.State state;

        StatePredicate(BlueTestResult.State state) {
            this.state = state;
        }

        public boolean apply(@Nullable BlueTestResult input) {
            return input != null && input.getTestState().equals((Object)this.state);
        }
    }

    static class StatusPredicate
    implements Predicate<BlueTestResult> {
        private final BlueTestResult.Status status;

        StatusPredicate(BlueTestResult.Status status) {
            this.status = status;
        }

        public boolean apply(@Nullable BlueTestResult input) {
            return input != null && input.getStatus().equals((Object)this.status);
        }
    }
}

