/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.service.embedded.rest;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import hudson.Extension;
import hudson.model.Run;
import io.jenkins.blueocean.rest.Reachable;
import io.jenkins.blueocean.rest.factory.BlueArtifactFactory;
import io.jenkins.blueocean.rest.hal.Link;
import io.jenkins.blueocean.rest.model.BlueArtifact;
import java.util.Collection;

public class ArtifactImpl
extends BlueArtifact {
    private final Run run;
    private final Run.Artifact artifact;

    public ArtifactImpl(Run run, Run.Artifact artifact, Link parent) {
        super(parent);
        this.run = run;
        this.artifact = artifact;
    }

    public String getName() {
        return this.artifact.getFileName();
    }

    public String getPath() {
        return this.artifact.relativePath;
    }

    public String getUrl() {
        return String.format("/%sartifact/%s", this.run.getUrl(), this.artifact.getHref());
    }

    public long getSize() {
        try {
            return this.artifact.getFileSize();
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    public boolean isDownloadable() {
        return true;
    }

    @Extension(ordinal=-1.0)
    public static class FactoryImpl
    extends BlueArtifactFactory {
        public Collection<BlueArtifact> getArtifacts(final Run<?, ?> run, final Reachable parent) {
            return Collections2.transform((Collection)run.getArtifacts(), (Function)new Function<Run.Artifact, BlueArtifact>(){

                public BlueArtifact apply(Run.Artifact artifact) {
                    return new ArtifactImpl(run, artifact, parent.getLink());
                }
            });
        }
    }
}

