/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.service.embedded.analytics;

import com.google.common.base.Objects;
import com.google.common.collect.Maps;
import com.google.common.hash.Hashing;
import hudson.ExtensionList;
import hudson.model.UsageStatistics;
import hudson.model.User;
import io.jenkins.blueocean.analytics.AdditionalAnalyticsProperties;
import io.jenkins.blueocean.analytics.Analytics;
import io.jenkins.blueocean.commons.ServiceException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.main.modules.instance_identity.InstanceIdentity;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.Stapler;

@Restricted(value={NoExternalUse.class})
public abstract class AbstractAnalytics
extends Analytics {
    private static final Logger LOGGER = Logger.getLogger(AbstractAnalytics.class.getName());

    public boolean isEnabled() {
        return !UsageStatistics.DISABLED;
    }

    public void track(Analytics.TrackRequest req) {
        if (req == null) {
            throw new ServiceException.BadRequestException("missing request");
        }
        if (StringUtils.isEmpty((String)req.name)) {
            throw new ServiceException.BadRequestException("missing name");
        }
        HashMap allProps = req.properties == null ? Maps.newHashMap() : Maps.newHashMap((Map)req.properties);
        for (AdditionalAnalyticsProperties enhancer : ExtensionList.lookup(AdditionalAnalyticsProperties.class)) {
            Map additionalProperties = enhancer.properties(req);
            if (additionalProperties == null) continue;
            allProps.putAll(additionalProperties);
        }
        String server = this.server();
        allProps.put("jenkins", server);
        if (Stapler.getCurrentRequest() != null) {
            String identity = this.identity(server);
            allProps.put("userId", identity);
        }
        Objects.ToStringHelper eventHelper = Objects.toStringHelper((Object)((Object)this)).add("name", (Object)req.name).add("props", (Object)allProps);
        try {
            this.doTrack(req.name, allProps);
            if (LOGGER.isLoggable(Level.FINE)) {
                String msg = eventHelper.toString();
                LOGGER.log(Level.FINE, msg);
            }
        }
        catch (Throwable throwable) {
            String msg = eventHelper.toString();
            LOGGER.log(Level.WARNING, "Failed to send event: " + msg);
        }
    }

    protected abstract void doTrack(String var1, Map<String, Object> var2);

    protected final String server() {
        byte[] identityBytes;
        try {
            identityBytes = InstanceIdentity.get().getPublic().getEncoded();
        }
        catch (AssertionError e) {
            LOGGER.log(Level.SEVERE, "There was a problem identifying this server", (Throwable)((Object)e));
            throw new IllegalStateException("There was a problem identifying this server", (Throwable)((Object)e));
        }
        return Hashing.sha256().hashBytes(identityBytes).toString();
    }

    protected final String identity(String server) {
        User user = User.current();
        String username = user == null ? "ANONYMOUS" : user.getId();
        return Hashing.sha256().hashString((CharSequence)(username + server)).toString();
    }
}

