/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.service.embedded.rest.junit;

import com.google.common.collect.Iterables;
import hudson.Extension;
import hudson.model.Run;
import hudson.tasks.junit.CaseResult;
import hudson.tasks.junit.TestResultAction;
import io.jenkins.blueocean.commons.ServiceException;
import io.jenkins.blueocean.rest.Reachable;
import io.jenkins.blueocean.rest.factory.BlueTestResultFactory;
import io.jenkins.blueocean.rest.hal.Link;
import io.jenkins.blueocean.rest.model.BlueTestResult;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public class BlueJUnitTestResult
extends BlueTestResult {
    protected final CaseResult testResult;

    public BlueJUnitTestResult(CaseResult testResult, Link parent) {
        super(parent);
        this.testResult = testResult;
    }

    public String getName() {
        return this.testResult.getDisplayName() + " \u2013 " + this.testResult.getClassName();
    }

    public BlueTestResult.Status getStatus() {
        BlueTestResult.Status status;
        switch (this.testResult.getStatus()) {
            case SKIPPED: {
                status = BlueTestResult.Status.SKIPPED;
                break;
            }
            case FAILED: 
            case REGRESSION: {
                status = BlueTestResult.Status.FAILED;
                break;
            }
            case PASSED: 
            case FIXED: {
                status = BlueTestResult.Status.PASSED;
                break;
            }
            default: {
                status = BlueTestResult.Status.UNKNOWN;
            }
        }
        return status;
    }

    public BlueTestResult.State getTestState() {
        BlueTestResult.State state;
        switch (this.testResult.getStatus()) {
            case REGRESSION: {
                state = BlueTestResult.State.REGRESSION;
                break;
            }
            case FIXED: {
                state = BlueTestResult.State.FIXED;
                break;
            }
            default: {
                state = BlueTestResult.State.UNKNOWN;
            }
        }
        return state;
    }

    public float getDuration() {
        return this.testResult.getDuration();
    }

    public String getErrorStackTrace() {
        return this.testResult.getErrorStackTrace();
    }

    public String getErrorDetails() {
        return this.testResult.getErrorDetails();
    }

    protected String getUniqueId() {
        return this.testResult.getClassName() + ":" + this.testResult.getId();
    }

    public int getAge() {
        int age = !this.testResult.isPassed() && this.testResult.getRun() != null ? this.testResult.getRun().getNumber() - this.testResult.getFailedSince() + 1 : 0;
        return age;
    }

    public String getStdErr() {
        return this.serveLog(this.testResult.getStderr());
    }

    public String getStdOut() {
        return this.serveLog(this.testResult.getStdout());
    }

    private String serveLog(String log) {
        if (StringUtils.isEmpty((String)log)) {
            throw new ServiceException.NotFoundException("No log");
        }
        return log;
    }

    @Extension
    public static class FactoryImpl
    extends BlueTestResultFactory {
        public BlueTestResultFactory.Result getBlueTestResults(Run<?, ?> run, Reachable parent) {
            TestResultAction action = (TestResultAction)run.getAction(TestResultAction.class);
            if (action == null) {
                return BlueTestResultFactory.Result.notFound();
            }
            ArrayList testsToTransform = new ArrayList();
            testsToTransform.addAll(action.getFailedTests());
            testsToTransform.addAll(action.getSkippedTests());
            testsToTransform.addAll(action.getPassedTests());
            return BlueTestResultFactory.Result.of((Iterable)Iterables.transform(testsToTransform, input -> new BlueJUnitTestResult((CaseResult)input, parent.getLink())));
        }
    }
}

