/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.service.embedded;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.model.ModelObject;
import io.jenkins.blueocean.rest.factory.BlueOceanUrlMapper;
import io.jenkins.blueocean.rest.model.BlueOceanUrlObject;
import io.jenkins.blueocean.service.embedded.BlueOceanUrlMapperImpl;
import io.jenkins.blueocean.service.embedded.Messages;
import java.util.Iterator;
import javax.annotation.Nonnull;

public class BlueOceanUrlObjectImpl
extends BlueOceanUrlObject {
    private final String mappedUrl;
    @SuppressFBWarnings(value={"UUF_UNUSED_FIELD"}, justification="Field is present to avoid deserialization errors for older version of this object")
    private transient ModelObject modelObject;

    public BlueOceanUrlObjectImpl(ModelObject modelObject) {
        this.mappedUrl = this.computeUrl(modelObject);
    }

    @Nonnull
    public String getDisplayName() {
        return Messages.BlueOceanUrlAction_DisplayName();
    }

    @Nonnull
    public String getUrl() {
        return this.mappedUrl;
    }

    @Nonnull
    public String getIconUrl() {
        return "/plugin/blueocean-rest-impl/images/48x48/blueocean.png";
    }

    private String computeUrl(ModelObject modelObject) {
        BlueOceanUrlMapper mapper;
        String url = null;
        Iterator iterator = BlueOceanUrlMapper.all().iterator();
        while (iterator.hasNext() && (url = (mapper = (BlueOceanUrlMapper)iterator.next()).getUrl(modelObject)) == null) {
        }
        if (url == null) {
            url = BlueOceanUrlMapperImpl.getLandingPagePath();
        }
        return url;
    }
}

