/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.service.embedded.rest;

import hudson.Extension;
import hudson.model.FreeStyleProject;
import hudson.model.Item;
import hudson.model.Job;
import io.jenkins.blueocean.rest.Reachable;
import io.jenkins.blueocean.rest.annotation.Capability;
import io.jenkins.blueocean.rest.factory.BluePipelineFactory;
import io.jenkins.blueocean.rest.model.BlueOrganization;
import io.jenkins.blueocean.rest.model.BluePipeline;
import io.jenkins.blueocean.rest.model.Resource;
import io.jenkins.blueocean.service.embedded.rest.AbstractPipelineImpl;

@Capability(value={"hudson.model.FreeStyleProject"})
public class FreeStylePipeline
extends AbstractPipelineImpl {
    private FreeStylePipeline(BlueOrganization organization, Job job) {
        super(organization, job);
    }

    @Extension(ordinal=1.0)
    public static class FactoryImpl
    extends BluePipelineFactory {
        public BluePipeline getPipeline(Item item, Reachable parent, BlueOrganization organization) {
            if (item instanceof FreeStyleProject) {
                FreeStyleProject job = (FreeStyleProject)item;
                return new FreeStylePipeline(organization, (Job)job);
            }
            return null;
        }

        public Resource resolve(Item context, Reachable parent, Item target, BlueOrganization organization) {
            if (context == target && target instanceof FreeStyleProject) {
                return this.getPipeline(target, parent, organization);
            }
            return null;
        }
    }
}

