/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.service.embedded.rest;

import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.google.common.collect.ImmutableMap;
import hudson.ExtensionList;
import hudson.model.Item;
import hudson.model.User;
import hudson.security.AccessControlled;
import hudson.tasks.Mailer;
import hudson.tasks.UserAvatarResolver;
import io.jenkins.blueocean.commons.ServiceException;
import io.jenkins.blueocean.rest.ApiHead;
import io.jenkins.blueocean.rest.Reachable;
import io.jenkins.blueocean.rest.UserRoute;
import io.jenkins.blueocean.rest.factory.organization.AbstractOrganization;
import io.jenkins.blueocean.rest.hal.Link;
import io.jenkins.blueocean.rest.model.BlueFavoriteContainer;
import io.jenkins.blueocean.rest.model.BlueOrganization;
import io.jenkins.blueocean.rest.model.BlueUser;
import io.jenkins.blueocean.rest.model.BlueUserPermission;
import io.jenkins.blueocean.service.embedded.rest.FavoriteContainerImpl;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import jenkins.model.ModifiableTopLevelItemGroup;
import org.acegisecurity.Authentication;
import org.apache.commons.lang.StringUtils;

public class UserImpl
extends BlueUser {
    private static final String CREDENTIAL_CREATE_PERMISSION = CredentialsProvider.CREATE.name.toLowerCase();
    private static final String CREDENTIAL_VIEW_PERMISSION = CredentialsProvider.VIEW.name.toLowerCase();
    private static final String CREDENTIAL_DELETE_PERMISSION = CredentialsProvider.DELETE.name.toLowerCase();
    private static final String CREDENTIAL_UPDATE_PERMISSION = CredentialsProvider.UPDATE.name.toLowerCase();
    private static final String CREDENTIAL_MANAGE_DOMAINS_PERMISSION = StringUtils.uncapitalize((String)CredentialsProvider.MANAGE_DOMAINS.name);
    protected final User user;
    private final BlueOrganization organization;
    private final AccessControlled organizationBase;
    private final Reachable parent;

    public UserImpl(@Nonnull BlueOrganization organization, @Nonnull User user, Reachable parent) {
        this.parent = parent;
        this.user = user;
        this.organization = organization;
        this.organizationBase = this.getAccessControllerOrganization();
    }

    public UserImpl(@Nonnull BlueOrganization organization, @Nonnull User user) {
        this(organization, user, null);
    }

    public String getId() {
        return this.user.getId();
    }

    public String getFullName() {
        return this.user.getFullName();
    }

    public String getEmail() {
        String name = Jenkins.getAuthentication().getName();
        if (this.isAnonymous(name)) {
            return null;
        }
        User user = User.get((String)name, (boolean)false, (Map)Collections.EMPTY_MAP);
        if (user == null) {
            return null;
        }
        if (!user.hasPermission(Jenkins.ADMINISTER)) {
            return null;
        }
        Mailer.UserProperty p = (Mailer.UserProperty)this.user.getProperty(Mailer.UserProperty.class);
        return p != null ? p.getAddress() : null;
    }

    public String getAvatar() {
        return UserAvatarResolver.resolveOrNull((User)this.user, (String)"48x48");
    }

    public BlueFavoriteContainer getFavorites() {
        String expectedUserId;
        User u = User.current();
        String string = expectedUserId = u != null ? u.getId() : Jenkins.ANONYMOUS.getName();
        if (!this.user.getId().equals(expectedUserId)) {
            throw new ServiceException.ForbiddenException("This user '" + expectedUserId + "' cannot access resource owned by '" + this.user.getId() + "'");
        }
        return new FavoriteContainerImpl(this, (Reachable)this);
    }

    public BlueUserPermission getPermission() {
        Authentication authentication = Jenkins.getAuthentication();
        String name = authentication.getName();
        if (this.isAnonymous(name)) {
            return null;
        }
        User loggedInUser = User.get((String)name, (boolean)false, (Map)Collections.EMPTY_MAP);
        if (loggedInUser == null) {
            return null;
        }
        if (!loggedInUser.getId().equals(this.user.getId())) {
            return null;
        }
        return new BlueUserPermission(){

            public boolean isAdministration() {
                return UserImpl.this.isAdmin();
            }

            public Map<String, Boolean> getPipelinePermission() {
                return UserImpl.this.getPipelinePermissions();
            }

            public Map<String, Boolean> getCredentialPermission() {
                return UserImpl.this.getCredentialPermissions();
            }
        };
    }

    public Link getLink() {
        return this.parent != null ? this.parent.getLink().rel(this.getId()) : ApiHead.INSTANCE().getLink().rel("users/" + this.getId());
    }

    public Object getDynamic(String route) {
        for (UserRoute userRoute : ExtensionList.lookup(UserRoute.class)) {
            if (userRoute.getUrlName() == null || !userRoute.getUrlName().equals(route)) continue;
            return userRoute.get((BlueUser)this);
        }
        return null;
    }

    private boolean isAdmin() {
        return Jenkins.getInstance().hasPermission(Jenkins.ADMINISTER);
    }

    private Map<String, Boolean> getPipelinePermissions() {
        return ImmutableMap.of((Object)"create", (Object)this.organizationBase.hasPermission(Item.CREATE), (Object)"read", (Object)this.organizationBase.hasPermission(Item.READ), (Object)"start", (Object)this.organizationBase.hasPermission(Item.BUILD), (Object)"stop", (Object)this.organizationBase.hasPermission(Item.CANCEL), (Object)"configure", (Object)this.organizationBase.hasPermission(Item.CONFIGURE));
    }

    private Map<String, Boolean> getCredentialPermissions() {
        return ImmutableMap.of((Object)CREDENTIAL_CREATE_PERMISSION, (Object)this.organizationBase.hasPermission(CredentialsProvider.CREATE), (Object)CREDENTIAL_VIEW_PERMISSION, (Object)this.organizationBase.hasPermission(CredentialsProvider.VIEW), (Object)CREDENTIAL_DELETE_PERMISSION, (Object)this.organizationBase.hasPermission(CredentialsProvider.DELETE), (Object)CREDENTIAL_UPDATE_PERMISSION, (Object)this.organizationBase.hasPermission(CredentialsProvider.UPDATE), (Object)CREDENTIAL_MANAGE_DOMAINS_PERMISSION, (Object)this.organizationBase.hasPermission(CredentialsProvider.MANAGE_DOMAINS));
    }

    private boolean isAnonymous(String name) {
        return name.equals("anonymous") || this.user.getId().equals("anonymous");
    }

    private AccessControlled getAccessControllerOrganization() {
        ModifiableTopLevelItemGroup group;
        Jenkins orgBase = Jenkins.getInstance();
        if (this.organization instanceof AbstractOrganization && (group = ((AbstractOrganization)this.organization).getGroup()) instanceof AccessControlled) {
            orgBase = (AccessControlled)group;
        }
        return orgBase;
    }
}

