/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.service.embedded.rest;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import hudson.Extension;
import hudson.model.AbstractItem;
import hudson.model.Item;
import hudson.model.ItemGroup;
import io.jenkins.blueocean.commons.ServiceException;
import io.jenkins.blueocean.rest.Reachable;
import io.jenkins.blueocean.rest.factory.BluePipelineFactory;
import io.jenkins.blueocean.rest.hal.Link;
import io.jenkins.blueocean.rest.model.BlueActionProxy;
import io.jenkins.blueocean.rest.model.BlueFavorite;
import io.jenkins.blueocean.rest.model.BlueFavoriteAction;
import io.jenkins.blueocean.rest.model.BlueIcon;
import io.jenkins.blueocean.rest.model.BlueOrganization;
import io.jenkins.blueocean.rest.model.BluePipeline;
import io.jenkins.blueocean.rest.model.BluePipelineContainer;
import io.jenkins.blueocean.rest.model.BluePipelineFolder;
import io.jenkins.blueocean.rest.model.BluePipelineScm;
import io.jenkins.blueocean.rest.model.BlueTrendContainer;
import io.jenkins.blueocean.rest.model.Resource;
import io.jenkins.blueocean.service.embedded.rest.AbstractPipelineImpl;
import io.jenkins.blueocean.service.embedded.rest.PipelineContainerImpl;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.kohsuke.stapler.json.JsonBody;

public class PipelineFolderImpl
extends BluePipelineFolder {
    protected final BlueOrganization organization;
    private final ItemGroup folder;
    protected final Link parent;

    public PipelineFolderImpl(BlueOrganization organization, ItemGroup folder, Link parent) {
        this.organization = organization;
        this.folder = folder;
        this.parent = parent;
    }

    public String getOrganizationName() {
        return this.organization.getName();
    }

    @Nonnull
    public BlueOrganization getOrganization() {
        return this.organization;
    }

    public String getName() {
        if (this.folder instanceof AbstractItem) {
            return ((AbstractItem)this.folder).getName();
        }
        return this.folder.getDisplayName();
    }

    public String getDisplayName() {
        return this.folder.getDisplayName();
    }

    public String getFullName() {
        if (this.folder instanceof Item) {
            return AbstractPipelineImpl.getFullName(this.organization, (Item)this.folder);
        }
        return null;
    }

    public String getFullDisplayName() {
        if (this.folder instanceof Item) {
            return AbstractPipelineImpl.getFullDisplayName(this.organization, (Item)this.folder);
        }
        return this.folder.getDisplayName();
    }

    public Collection<BlueActionProxy> getActions() {
        return Collections.emptyList();
    }

    public List<Object> getParameters() {
        return null;
    }

    public BluePipelineContainer getPipelines() {
        return new PipelineContainerImpl(this.organization, this.folder, (Reachable)this);
    }

    public Integer getNumberOfFolders() {
        int count = 0;
        for (BluePipeline p : this.getPipelines()) {
            if (!(p instanceof BluePipelineFolder)) continue;
            ++count;
        }
        return count;
    }

    public Integer getNumberOfPipelines() {
        int count = 0;
        for (BluePipeline p : this.getPipelines()) {
            if (p instanceof BluePipelineFolder) continue;
            ++count;
        }
        return count;
    }

    public BlueFavorite favorite(@JsonBody BlueFavoriteAction favoriteAction) {
        throw new ServiceException.MethodNotAllowedException("Cannot favorite a folder");
    }

    public Map<String, Boolean> getPermissions() {
        if (this.folder instanceof AbstractItem) {
            AbstractItem item = (AbstractItem)this.folder;
            return AbstractPipelineImpl.getPermissions(item);
        }
        return null;
    }

    public BluePipelineScm getScm() {
        return null;
    }

    public Link getLink() {
        return this.organization.getLink().rel("pipelines").rel(AbstractPipelineImpl.getRecursivePathFromFullName((BluePipeline)this));
    }

    public BlueIcon getIcon() {
        return null;
    }

    public Iterable<String> getPipelineFolderNames() {
        return Iterables.transform((Iterable)this.getPipelines(), (Function)new Function<BluePipeline, String>(){

            public String apply(@Nullable BluePipeline input) {
                if (input != null && input instanceof BluePipelineFolder) {
                    return input.getName();
                }
                return null;
            }
        });
    }

    public BlueTrendContainer getTrends() {
        return null;
    }

    @Extension(ordinal=-10.0)
    public static class PipelineFactoryImpl
    extends BluePipelineFactory {
        public PipelineFolderImpl getPipeline(Item item, Reachable parent, BlueOrganization organization) {
            if (item instanceof ItemGroup) {
                return new PipelineFolderImpl(organization, (ItemGroup)item, parent.getLink());
            }
            return null;
        }

        public Resource resolve(Item context, Reachable parent, Item target, BlueOrganization organization) {
            PipelineFolderImpl folder = this.getPipeline(context, parent, organization);
            if (folder != null) {
                if (context == target) {
                    return folder;
                }
                Item nextChild = PipelineFactoryImpl.findNextStep((ItemGroup)folder.folder, (Item)target);
                for (BluePipelineFactory f : PipelineFactoryImpl.all()) {
                    Resource answer = f.resolve(nextChild, (Reachable)folder, target, organization);
                    if (answer == null) continue;
                    return answer;
                }
            }
            return null;
        }
    }
}

