/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.service.embedded.rest;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import hudson.Functions;
import hudson.model.Run;
import io.jenkins.blueocean.rest.Reachable;
import io.jenkins.blueocean.rest.factory.BlueArtifactFactory;
import io.jenkins.blueocean.rest.hal.Link;
import io.jenkins.blueocean.rest.model.BlueArtifact;
import io.jenkins.blueocean.rest.model.BlueArtifactContainer;
import java.util.Iterator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ArtifactContainerImpl
extends BlueArtifactContainer {
    private final Run run;
    private final Link self;

    public ArtifactContainerImpl(Run r, Reachable parent) {
        this.run = r;
        this.self = parent.getLink().rel("artifacts");
    }

    public Link getLink() {
        return this.self;
    }

    public BlueArtifact get(final String name) {
        if (Functions.isArtifactsPermissionEnabled() && !this.run.hasPermission(Run.ARTIFACTS)) {
            return null;
        }
        return (BlueArtifact)Iterators.find(this.iterator(), (Predicate)new Predicate<BlueArtifact>(){

            public boolean apply(@Nullable BlueArtifact input) {
                return input != null && input.getId().equals(name);
            }
        }, null);
    }

    @Nonnull
    public Iterator<BlueArtifact> iterator() {
        if (Functions.isArtifactsPermissionEnabled() && !this.run.hasPermission(Run.ARTIFACTS)) {
            return ImmutableList.of().iterator();
        }
        return BlueArtifactFactory.resolve((Run)this.run, (Reachable)this).iterator();
    }
}

