/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.service.embedded.analytics;

import com.google.common.collect.Maps;
import hudson.Extension;
import io.jenkins.blueocean.analytics.AdditionalAnalyticsProperties;
import io.jenkins.blueocean.analytics.Analytics;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;
import ua_parser.Client;
import ua_parser.Parser;

@Extension
public class BrowserAndOperatingSystemAnalyticsProperties
extends AdditionalAnalyticsProperties {
    private static final Logger LOGGER;
    private static final Parser PARSER;

    public Map<String, Object> properties(Analytics.TrackRequest req) {
        String operatingSystemFamily;
        String browserVersionMinor;
        StaplerRequest httpReq = Stapler.getCurrentRequest();
        if (PARSER == null || httpReq == null) {
            return null;
        }
        String userAgent = httpReq.getHeader("User-Agent");
        if (userAgent == null) {
            return null;
        }
        Client client = PARSER.parse(userAgent);
        String browserFamily = client.userAgent.family;
        if (browserFamily == null) {
            return null;
        }
        HashMap props = Maps.newHashMap();
        props.put("browserFamily", browserFamily);
        String browserVersionMajor = client.userAgent.major;
        if (StringUtils.isNotEmpty((String)browserVersionMajor)) {
            props.put("browserVersionMajor", browserVersionMajor);
        }
        if (StringUtils.isNotEmpty((String)(browserVersionMinor = client.userAgent.minor))) {
            props.put("browserVersionMinor", browserVersionMinor);
        }
        if (StringUtils.isNotEmpty((String)(operatingSystemFamily = client.os.family))) {
            String osVersionMinor;
            props.put("osFamily", operatingSystemFamily);
            String osVersionMajor = client.os.major;
            if (StringUtils.isNotEmpty((String)osVersionMajor)) {
                props.put("osVersionMajor", osVersionMajor);
            }
            if (StringUtils.isNotEmpty((String)(osVersionMinor = client.os.minor))) {
                props.put("osVersionMinor", osVersionMinor);
            }
        }
        return props;
    }

    static {
        Parser parser;
        LOGGER = Logger.getLogger(BrowserAndOperatingSystemAnalyticsProperties.class.getName());
        try {
            parser = new Parser();
        }
        catch (IOException e) {
            parser = null;
            LOGGER.log(Level.SEVERE, "There was a problem loading the UAParser. Browser detection is unavailable.", e);
        }
        PARSER = parser;
    }
}

