/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.service.embedded.rest;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Collections2;
import hudson.model.Action;
import hudson.model.Cause;
import hudson.model.CauseAction;
import hudson.model.Result;
import hudson.model.Run;
import io.jenkins.blueocean.commons.ServiceException;
import io.jenkins.blueocean.rest.Reachable;
import io.jenkins.blueocean.rest.factory.BlueTestResultFactory;
import io.jenkins.blueocean.rest.hal.Link;
import io.jenkins.blueocean.rest.hal.Links;
import io.jenkins.blueocean.rest.model.BlueActionProxy;
import io.jenkins.blueocean.rest.model.BlueArtifactContainer;
import io.jenkins.blueocean.rest.model.BlueChangeSetEntry;
import io.jenkins.blueocean.rest.model.BlueOrganization;
import io.jenkins.blueocean.rest.model.BluePipelineNodeContainer;
import io.jenkins.blueocean.rest.model.BluePipelineStepContainer;
import io.jenkins.blueocean.rest.model.BlueRun;
import io.jenkins.blueocean.rest.model.BlueTestResultContainer;
import io.jenkins.blueocean.rest.model.BlueTestSummary;
import io.jenkins.blueocean.rest.model.Container;
import io.jenkins.blueocean.rest.model.Containers;
import io.jenkins.blueocean.rest.model.GenericResource;
import io.jenkins.blueocean.service.embedded.rest.ActionProxiesImpl;
import io.jenkins.blueocean.service.embedded.rest.ArtifactContainerImpl;
import io.jenkins.blueocean.service.embedded.rest.BlueTestResultContainerImpl;
import io.jenkins.blueocean.service.embedded.rest.LogResource;
import io.jenkins.blueocean.service.embedded.rest.StoppableRun;
import java.util.Collection;
import java.util.Date;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.kohsuke.stapler.QueryParameter;

public abstract class AbstractRunImpl<T extends Run>
extends BlueRun {
    public static final DateTimeFormatter DATE_FORMAT = DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    private static final Logger LOGGER = Logger.getLogger(AbstractRunImpl.class.getName());
    private static final long TEST_SUMMARY_CACHE_MAX_SIZE = Long.getLong("TEST_SUMMARY_CACHE_MAX_SIZE", 10000L);
    private static final Cache<String, Optional<BlueTestSummary>> TEST_SUMMARY = CacheBuilder.newBuilder().maximumSize(TEST_SUMMARY_CACHE_MAX_SIZE).expireAfterAccess(1L, TimeUnit.DAYS).build();
    protected final T run;
    protected final BlueOrganization organization;
    protected final Reachable parent;

    public AbstractRunImpl(T run, Reachable parent, BlueOrganization organization) {
        this.run = run;
        this.parent = parent;
        this.organization = organization;
    }

    @Nonnull
    public Container<BlueChangeSetEntry> getChangeSet() {
        return Containers.empty((Link)this.getLink());
    }

    public String getOrganization() {
        return this.organization.getName();
    }

    public String getId() {
        return this.run.getId();
    }

    public String getPipeline() {
        return this.run.getParent().getName();
    }

    public String getName() {
        String displayName;
        String defaultName = "#" + this.run.getNumber();
        return defaultName.equals(displayName = this.run.getDisplayName()) ? null : displayName;
    }

    public String getDescription() {
        return this.run.getDescription();
    }

    public Date getStartTime() {
        return new Date(this.run.getStartTimeInMillis());
    }

    public Date getEnQueueTime() {
        return new Date(this.run.getTimeInMillis());
    }

    public String getEnQueueTimeString() {
        return DATE_FORMAT.print(this.getEnQueueTime().getTime());
    }

    public String getStartTimeString() {
        return DATE_FORMAT.print(this.getStartTime().getTime());
    }

    public String getEndTimeString() {
        Date endTime = this.getEndTime();
        if (endTime == null) {
            return null;
        }
        return DATE_FORMAT.print(endTime.getTime());
    }

    public BlueRun.BlueRunState getStateObj() {
        if (!this.run.hasntStartedYet() && this.run.isLogUpdated()) {
            return BlueRun.BlueRunState.RUNNING;
        }
        if (!this.run.isLogUpdated()) {
            return BlueRun.BlueRunState.FINISHED;
        }
        return BlueRun.BlueRunState.RUNNING;
    }

    public BlueRun.BlueRunResult getResult() {
        if (this.getStateObj() == BlueRun.BlueRunState.RUNNING) {
            return BlueRun.BlueRunResult.UNKNOWN;
        }
        Result result = this.run.getResult();
        return result != null ? BlueRun.BlueRunResult.valueOf((String)result.toString()) : BlueRun.BlueRunResult.UNKNOWN;
    }

    public Date getEndTime() {
        if (!this.run.isBuilding()) {
            return new Date(this.run.getStartTimeInMillis() + this.run.getDuration());
        }
        return null;
    }

    public Long getDurationInMillis() {
        return this.run.getDuration();
    }

    public Long getEstimatedDurtionInMillis() {
        return this.run.getEstimatedDuration();
    }

    public String getRunSummary() {
        return this.run.getBuildStatusSummary().message;
    }

    public String getType() {
        return this.run.getClass().getSimpleName();
    }

    public Object getLog() {
        return new LogResource(this.run.getLogText());
    }

    public BlueRun replay() {
        return null;
    }

    public Collection<BlueRun.BlueCause> getCauses() {
        return BlueCauseImpl.getCauses(this.run);
    }

    public String getCauseOfBlockage() {
        return null;
    }

    public boolean isReplayable() {
        return false;
    }

    public BlueArtifactContainer getArtifacts() {
        return new ArtifactContainerImpl((Run)this.run, (Reachable)this);
    }

    public BluePipelineNodeContainer getNodes() {
        return null;
    }

    public BluePipelineStepContainer getSteps() {
        return null;
    }

    public BlueTestResultContainer getTests() {
        return new BlueTestResultContainerImpl(this, (Run<?, ?>)this.run);
    }

    public BlueTestSummary getTestSummary() {
        if (this.getStateObj() == BlueRun.BlueRunState.FINISHED) {
            try {
                return (BlueTestSummary)((Optional)TEST_SUMMARY.get((Object)this.run.getExternalizableId(), (Callable)new Callable<Optional<BlueTestSummary>>(){

                    @Override
                    public Optional<BlueTestSummary> call() throws Exception {
                        BlueTestSummary summary = BlueTestResultFactory.resolve(AbstractRunImpl.this.run, (Reachable)AbstractRunImpl.this.parent).summary;
                        return summary == null ? Optional.absent() : Optional.of((Object)summary);
                    }
                })).orNull();
            }
            catch (ExecutionException e) {
                LOGGER.log(Level.SEVERE, "Could not load summary from cache", e);
                return null;
            }
        }
        return BlueTestResultFactory.resolve(this.run, (Reachable)this).summary;
    }

    public Collection<BlueActionProxy> getActions() {
        return ActionProxiesImpl.getActionProxies(this.run.getAllActions(), (Reachable)this);
    }

    public BlueRun stop(@QueryParameter(value="blocking") Boolean blocking, @QueryParameter(value="timeOutInSecs") Integer timeOutInSecs) {
        throw new ServiceException.NotImplementedException("Stop should be implemented on a subclass");
    }

    public String getArtifactsZipFile() {
        return "/" + this.run.getUrl() + "artifact/*zip*/archive.zip";
    }

    protected BlueRun stop(Boolean blocking, Integer timeOutInSecs, StoppableRun stoppableRun) {
        if (blocking == null) {
            blocking = false;
        }
        try {
            long start = System.currentTimeMillis();
            if (timeOutInSecs == null) {
                timeOutInSecs = 10;
            }
            if (timeOutInSecs < 0) {
                throw new ServiceException.BadRequestException("timeOutInSecs must be >= 0");
            }
            stoppableRun.stop();
            long timeOutInMillis = timeOutInSecs * 1000;
            long sleepingInterval = timeOutInMillis / 10L;
            do {
                if (this.isCompletedOrAborted()) {
                    return this;
                }
                Thread.sleep(sleepingInterval);
            } while (blocking.booleanValue() && System.currentTimeMillis() - start < timeOutInMillis);
        }
        catch (Exception e) {
            throw new ServiceException.UnexpectedErrorException(String.format("Failed to stop run %s: %s", this.run.getId(), e.getMessage()), (Throwable)e);
        }
        return this;
    }

    public Object getDynamic(String token) {
        for (Action a : this.run.getAllActions()) {
            if (!token.equals(a.getUrlName())) continue;
            return new GenericResource((Object)a);
        }
        return null;
    }

    public Link getLink() {
        if (this.parent == null) {
            return this.organization.getLink().rel(String.format("pipelines/%s/runs/%s", this.run.getParent().getName(), this.getId()));
        }
        return this.parent.getLink().rel("runs/" + this.getId());
    }

    private boolean isCompletedOrAborted() {
        Result result = this.run.getResult();
        return result != null && (result == Result.ABORTED || result.isCompleteBuild());
    }

    public Links getLinks() {
        return super.getLinks().add("parent", this.parent.getLink());
    }

    public static class BlueCauseImpl
    extends BlueRun.BlueCause {
        private final Cause cause;

        BlueCauseImpl(Cause cause) {
            this.cause = cause;
        }

        public String getShortDescription() {
            return this.cause.getShortDescription();
        }

        public Object getCause() {
            return this.cause;
        }

        static Collection<BlueRun.BlueCause> getCauses(Run run) {
            CauseAction action = (CauseAction)run.getAction(CauseAction.class);
            if (action == null) {
                return null;
            }
            return BlueCauseImpl.getCauses(action.getCauses());
        }

        static Collection<BlueRun.BlueCause> getCauses(Collection<Cause> causes) {
            return Collections2.transform(causes, (Function)new Function<Cause, BlueRun.BlueCause>(){

                public BlueRun.BlueCause apply(@Nullable Cause input) {
                    return new BlueCauseImpl(input);
                }
            });
        }
    }
}

