/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.service.embedded;

import hudson.Extension;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Job;
import hudson.model.Run;
import io.jenkins.blueocean.rest.factory.BluePipelineFactory;
import io.jenkins.blueocean.rest.hal.Link;
import io.jenkins.blueocean.rest.hal.LinkResolver;
import io.jenkins.blueocean.rest.model.BluePipeline;
import io.jenkins.blueocean.rest.model.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Extension
public class LinkResolverImpl
extends LinkResolver {
    private final Logger logger = LoggerFactory.getLogger(LinkResolverImpl.class);

    public Link resolve(Object modelObject) {
        Run run;
        Resource resource;
        if (modelObject instanceof Job) {
            Resource resource2 = this.resolveJob((Job)modelObject);
            if (resource2 != null) {
                return resource2.getLink();
            }
        } else if (modelObject instanceof Item && modelObject instanceof ItemGroup) {
            Resource resource3 = this.resolveFolder((Item)modelObject);
            if (resource3 != null) {
                return resource3.getLink();
            }
        } else if (modelObject instanceof Run && (resource = this.resolveRun(run = (Run)modelObject)) != null) {
            return resource.getLink();
        }
        return null;
    }

    private Resource resolveJob(Job job) {
        return BluePipelineFactory.resolve((Item)job);
    }

    private Resource resolveFolder(Item folder) {
        return BluePipelineFactory.resolve((Item)folder);
    }

    private Resource resolveRun(Run run) {
        Resource resource = this.resolveJob(run.getParent());
        if (resource instanceof BluePipeline) {
            BluePipeline pipeline = (BluePipeline)resource;
            return (Resource)pipeline.getRuns().get(run.getId());
        }
        return null;
    }
}

