/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.service.embedded;

import hudson.model.ModelObject;
import io.jenkins.blueocean.rest.factory.BlueOceanUrlMapper;
import io.jenkins.blueocean.rest.model.BlueOceanUrlObject;
import io.jenkins.blueocean.service.embedded.BlueOceanUrlMapperImpl;
import io.jenkins.blueocean.service.embedded.Messages;
import java.util.Iterator;
import javax.annotation.Nonnull;

public class BlueOceanUrlObjectImpl
extends BlueOceanUrlObject {
    private volatile String mappedUrl;
    private final ModelObject modelObject;

    public BlueOceanUrlObjectImpl(ModelObject modelObject) {
        this.modelObject = modelObject;
    }

    @Nonnull
    public String getDisplayName() {
        return Messages.BlueOceanUrlAction_DisplayName();
    }

    @Nonnull
    public String getUrl() {
        this.setUrlIfNeeded();
        return this.mappedUrl;
    }

    @Nonnull
    public String getIconUrl() {
        return "/plugin/blueocean-rest-impl/images/48x48/blueocean.png";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setUrlIfNeeded() {
        String url = this.mappedUrl;
        if (url == null) {
            BlueOceanUrlObjectImpl blueOceanUrlObjectImpl = this;
            synchronized (blueOceanUrlObjectImpl) {
                url = this.mappedUrl;
                if (url == null) {
                    this.mappedUrl = url = this.computeUrl();
                }
            }
        }
    }

    private String computeUrl() {
        BlueOceanUrlMapper mapper;
        String url = null;
        Iterator iterator = BlueOceanUrlMapper.all().iterator();
        while (iterator.hasNext() && (url = (mapper = (BlueOceanUrlMapper)iterator.next()).getUrl(this.modelObject)) == null) {
        }
        if (url == null) {
            url = BlueOceanUrlMapperImpl.getLandingPagePath();
        }
        return url;
    }
}

