/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.service.embedded;

import com.cloudbees.hudson.plugins.folder.computed.ComputedFolder;
import hudson.Extension;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Job;
import hudson.model.ModelObject;
import hudson.model.Run;
import io.jenkins.blueocean.BlueOceanUIProvider;
import io.jenkins.blueocean.rest.factory.BlueOceanUrlMapper;
import io.jenkins.blueocean.rest.factory.BluePipelineFactory;
import io.jenkins.blueocean.rest.factory.organization.OrganizationFactory;
import io.jenkins.blueocean.rest.model.BlueMultiBranchPipeline;
import io.jenkins.blueocean.rest.model.BlueOrganization;
import io.jenkins.blueocean.rest.model.BluePipeline;
import io.jenkins.blueocean.rest.model.Resource;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Iterator;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jenkins.model.ModifiableTopLevelItemGroup;

@Extension(ordinal=-9999.0)
public class BlueOceanUrlMapperImpl
extends BlueOceanUrlMapper {
    public String getUrl(@Nonnull ModelObject modelObject) {
        Resource bluePipeline;
        BlueOrganization organization = this.getOrganization(modelObject);
        if (organization == null) {
            return BlueOceanUrlMapperImpl.getLandingPagePath();
        }
        String organizationName = organization.getName();
        String baseUrl = this.getOrgPrefix(organizationName);
        if (modelObject instanceof ModifiableTopLevelItemGroup) {
            return baseUrl;
        }
        if (modelObject instanceof Job) {
            BluePipeline blueResource = this.getJobResource(modelObject);
            if (blueResource != null) {
                return this.getPipelineUrl(baseUrl, blueResource);
            }
        } else if (modelObject instanceof Run) {
            Run run = (Run)modelObject;
            Job job = run.getParent();
            BluePipeline blueResource = this.getJobResource((ModelObject)job);
            if (blueResource != null) {
                return baseUrl + "/" + this.encodeURIComponent(blueResource.getFullName()) + "/detail/" + this.encodeURIComponent(this.decodeURIComponent(job.getName())) + "/" + this.encodeURIComponent(run.getId());
            }
        } else if (modelObject instanceof Item && (bluePipeline = BluePipelineFactory.resolve((Item)((Item)modelObject))) instanceof BlueMultiBranchPipeline) {
            return this.getPipelineUrl(baseUrl, (BluePipeline)bluePipeline);
        }
        return null;
    }

    private String getPipelineUrl(String baseUrl, BluePipeline pipeline) {
        if (pipeline instanceof BlueMultiBranchPipeline) {
            return baseUrl + "/" + this.encodeURIComponent(pipeline.getFullName()) + "/branches";
        }
        return baseUrl + "/" + this.encodeURIComponent(pipeline.getFullName());
    }

    @CheckForNull
    private BluePipeline getJobResource(ModelObject modelObject) {
        BluePipeline blueResource = null;
        if (modelObject instanceof Job) {
            ItemGroup parent = ((Job)modelObject).getParent();
            if (parent instanceof ComputedFolder) {
                blueResource = (BluePipeline)BluePipelineFactory.resolve((Item)((ComputedFolder)parent));
                if (blueResource instanceof BlueMultiBranchPipeline) {
                    return blueResource;
                }
            } else {
                blueResource = (BluePipeline)BluePipelineFactory.resolve((Item)((Job)modelObject));
            }
        }
        return blueResource;
    }

    private boolean isBranch(ModelObject modelObject) {
        ItemGroup parent;
        if (modelObject instanceof Job && (parent = ((Job)modelObject).getParent()) instanceof ComputedFolder) {
            BluePipeline blueResource = (BluePipeline)BluePipelineFactory.resolve((Item)((Job)modelObject));
            return blueResource instanceof BlueMultiBranchPipeline;
        }
        return false;
    }

    static String getLandingPagePath() {
        Iterator iterator = BlueOceanUIProvider.all().iterator();
        if (iterator.hasNext()) {
            BlueOceanUIProvider p = (BlueOceanUIProvider)iterator.next();
            return String.format("%s%s", BlueOceanUrlMapperImpl.getBlueHome(), p.getLandingPagePath());
        }
        return BlueOceanUrlMapperImpl.getBlueHome();
    }

    private static String getBlueHome() {
        Iterator iterator = BlueOceanUIProvider.all().iterator();
        if (iterator.hasNext()) {
            BlueOceanUIProvider p = (BlueOceanUIProvider)iterator.next();
            return p.getUrlBasePrefix();
        }
        return "blue";
    }

    private String decodeURIComponent(String string) {
        try {
            return URLDecoder.decode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Unexpected UTF-8 encoding error.", e);
        }
    }

    private String encodeURIComponent(String string) {
        try {
            return URLEncoder.encode(string, "UTF-8").replace("+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Unexpected UTF-8 encoding error.", e);
        }
    }

    private BlueOrganization getOrganization(ModelObject modelObject) {
        BlueOrganization organization = null;
        if (modelObject instanceof Item) {
            organization = OrganizationFactory.getInstance().getContainingOrg((Item)modelObject);
        } else if (modelObject instanceof ItemGroup) {
            organization = OrganizationFactory.getInstance().getContainingOrg((ItemGroup)modelObject);
        } else if (modelObject instanceof Run) {
            organization = OrganizationFactory.getInstance().getContainingOrg((Item)((Run)modelObject).getParent());
        }
        return organization;
    }

    private String getOrgPrefix(String organization) {
        return String.format("%s/organizations/%s", BlueOceanUrlMapperImpl.getBlueHome(), organization);
    }
}

