/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.service.embedded.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.RSAPublicKey;

public class SSHKeyUtils {
    public static KeyPair generateRSAKey(int keySize) {
        try {
            KeyPairGenerator generator = KeyPairGenerator.getInstance("RSA");
            generator.initialize(keySize);
            return generator.genKeyPair();
        }
        catch (NoSuchAlgorithmException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static byte[] encodePublicKey(RSAPublicKey key) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] sshrsa = new byte[]{0, 0, 0, 7, 115, 115, 104, 45, 114, 115, 97};
            out.write(sshrsa);
            BigInteger e = key.getPublicExponent();
            byte[] data = e.toByteArray();
            SSHKeyUtils.encodeUInt32(data.length, out);
            out.write(data);
            BigInteger m = key.getModulus();
            data = m.toByteArray();
            SSHKeyUtils.encodeUInt32(data.length, out);
            out.write(data);
            return out.toByteArray();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static void encodeUInt32(int value, OutputStream out) throws IOException {
        byte[] tmp = new byte[]{(byte)(value >>> 24 & 0xFF), (byte)(value >>> 16 & 0xFF), (byte)(value >>> 8 & 0xFF), (byte)(value & 0xFF)};
        out.write(tmp);
    }
}

