/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.service.embedded.rest;

import com.cloudbees.hudson.plugins.folder.AbstractFolder;
import hudson.model.Item;
import hudson.model.User;
import hudson.plugins.favorite.Favorites;
import io.jenkins.blueocean.rest.Reachable;
import io.jenkins.blueocean.rest.hal.Link;
import io.jenkins.blueocean.rest.model.BlueFavorite;
import io.jenkins.blueocean.rest.model.BlueFavoriteContainer;
import io.jenkins.blueocean.service.embedded.rest.UserImpl;
import io.jenkins.blueocean.service.embedded.util.FavoriteUtil;
import java.util.ArrayList;
import java.util.Iterator;
import jenkins.model.Jenkins;

public class FavoriteContainerImpl
extends BlueFavoriteContainer {
    private final UserImpl user;
    private final Link self;

    public FavoriteContainerImpl(UserImpl user, Reachable parent) {
        this.user = user;
        this.self = parent.getLink().rel("favorites");
    }

    public BlueFavorite get(String name) {
        name = FavoriteUtil.decodeFullName(name);
        Item item = Jenkins.getInstance().getItemByFullName(name);
        if (item != null && Favorites.isFavorite((User)this.user.user, (Item)item)) {
            return FavoriteUtil.getFavorite(item, (Reachable)this);
        }
        return null;
    }

    public Iterator<BlueFavorite> iterator() {
        ArrayList<BlueFavorite> favorites = new ArrayList<BlueFavorite>();
        for (Item favorite : Favorites.getFavorites((User)this.user.user)) {
            BlueFavorite blueFavorite;
            if (favorite instanceof AbstractFolder || (blueFavorite = FavoriteUtil.getFavorite(favorite)) == null) continue;
            favorites.add(blueFavorite);
        }
        return favorites.iterator();
    }

    public Link getLink() {
        return this.self;
    }
}

