/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.service.embedded.analytics;

import com.google.common.base.Objects;
import com.google.common.collect.Maps;
import com.google.common.hash.Hashing;
import hudson.ExtensionList;
import hudson.model.User;
import io.jenkins.blueocean.analytics.AdditionalAnalyticsProperties;
import io.jenkins.blueocean.analytics.Analytics;
import io.jenkins.blueocean.commons.ServiceException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.main.modules.instance_identity.InstanceIdentity;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public abstract class AbstractAnalytics
extends Analytics {
    private static final Logger LOGGER = Logger.getLogger(AbstractAnalytics.class.getName());

    public void track(Analytics.TrackRequest req) {
        if (req == null) {
            throw new ServiceException.BadRequestException("missing request");
        }
        if (StringUtils.isEmpty((String)req.name)) {
            throw new ServiceException.BadRequestException("missing name");
        }
        HashMap allProps = req.properties == null ? Maps.newHashMap() : Maps.newHashMap((Map)req.properties);
        for (AdditionalAnalyticsProperties enhancer : ExtensionList.lookup(AdditionalAnalyticsProperties.class)) {
            Map additionalProperties = enhancer.properties(req);
            if (additionalProperties == null) continue;
            allProps.putAll(additionalProperties);
        }
        allProps.put("jenkins", this.server());
        allProps.put("userId", this.identity());
        String msg = Objects.toStringHelper((Object)((Object)this)).add("name", (Object)req.name).add("props", (Object)allProps).toString();
        try {
            this.doTrack(req.name, allProps);
            LOGGER.log(Level.FINE, msg);
        }
        catch (Throwable throwable) {
            LOGGER.log(Level.WARNING, "Failed to send event: " + msg);
        }
    }

    protected abstract void doTrack(String var1, Map<String, Object> var2);

    protected final String server() {
        return Hashing.sha256().hashBytes(InstanceIdentity.get().getPublic().getEncoded()).toString();
    }

    protected final String identity() {
        User user = User.current();
        String username = user == null ? "ANONYMOUS" : user.getId();
        return Hashing.sha256().hashString((CharSequence)(username + this.server())).toString();
    }
}

