/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.service.embedded.util;

import com.cloudbees.jenkins.plugins.sshcredentials.impl.BasicSSHUserPrivateKey;
import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.CredentialsStore;
import com.cloudbees.plugins.credentials.domains.Domain;
import com.google.common.base.Preconditions;
import hudson.model.ModelObject;
import hudson.model.User;
import hudson.remoting.Base64;
import io.jenkins.blueocean.commons.ServiceException;
import io.jenkins.blueocean.service.embedded.util.SSHKeyUtils;
import java.io.IOException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPublicKeySpec;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public class UserSSHKeyManager {
    private static final int KEY_SIZE = 2048;
    private static final String BLUEOCEAN_GENERATED_SSH_KEY_ID = "jenkins-generated-ssh-key";
    private static final String BLUEOCEAN_DOMAIN_NAME = "blueocean-private-key-domain";

    @Nonnull
    public static BasicSSHUserPrivateKey getOrCreate(@Nonnull User user) {
        Preconditions.checkNotNull((Object)user);
        CredentialsStore store = UserSSHKeyManager.getUserStore(user);
        if (store == null) {
            throw new ServiceException.ForbiddenException(String.format("Logged in user: %s doesn't have writable credentials store", user.getId()));
        }
        for (Credentials cred : store.getCredentials(UserSSHKeyManager.getDomain(store))) {
            BasicSSHUserPrivateKey sshKey;
            if (!(cred instanceof BasicSSHUserPrivateKey) || !BLUEOCEAN_GENERATED_SSH_KEY_ID.equals((sshKey = (BasicSSHUserPrivateKey)cred).getId())) continue;
            return sshKey;
        }
        try {
            KeyPair keyPair = SSHKeyUtils.generateRSAKey(2048);
            RSAPrivateKey privateKey = (RSAPrivateKey)keyPair.getPrivate();
            String id_rsa = Base64.encode((byte[])privateKey.getEncoded());
            BasicSSHUserPrivateKey.DirectEntryPrivateKeySource keySource = new BasicSSHUserPrivateKey.DirectEntryPrivateKeySource(id_rsa);
            BasicSSHUserPrivateKey key = new BasicSSHUserPrivateKey(CredentialsScope.USER, BLUEOCEAN_GENERATED_SSH_KEY_ID, user.getId(), (BasicSSHUserPrivateKey.PrivateKeySource)keySource, null, BLUEOCEAN_GENERATED_SSH_KEY_ID);
            store.addCredentials(UserSSHKeyManager.getDomain(store), (Credentials)key);
            store.save();
            return key;
        }
        catch (IOException ex) {
            throw new ServiceException.UnexpectedErrorException("Failed to create the private key", (Throwable)ex);
        }
    }

    @Nonnull
    public static String getReadablePublicKey(@Nonnull User user, @Nonnull BasicSSHUserPrivateKey key) {
        Preconditions.checkNotNull((Object)user);
        Preconditions.checkNotNull((Object)key);
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(Base64.decode((String)key.getPrivateKey()));
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            RSAPrivateCrtKey privateKey = (RSAPrivateCrtKey)keyFactory.generatePrivate(keySpec);
            RSAPublicKeySpec publicKeySpec = new RSAPublicKeySpec(privateKey.getModulus(), privateKey.getPublicExponent());
            RSAPublicKey publicKey = (RSAPublicKey)keyFactory.generatePublic(publicKeySpec);
            String id_rsa_pub = UserSSHKeyManager.getSSHPublicKey(publicKey, user);
            return id_rsa_pub;
        }
        catch (IOException | NoSuchAlgorithmException | InvalidKeySpecException ex) {
            throw new ServiceException.UnexpectedErrorException("Unable to get a readable public key", (Throwable)ex);
        }
    }

    public static void reset(@Nonnull User user) {
        Preconditions.checkNotNull((Object)user);
        try {
            CredentialsStore store = UserSSHKeyManager.getUserStore(user);
            if (store == null) {
                throw new ServiceException.ForbiddenException(String.format("Logged in user: %s doesn't have writable credentials store", user.getId()));
            }
            BasicSSHUserPrivateKey key = null;
            for (Credentials cred : store.getCredentials(UserSSHKeyManager.getDomain(store))) {
                BasicSSHUserPrivateKey sshKey;
                if (!(cred instanceof BasicSSHUserPrivateKey) || !BLUEOCEAN_GENERATED_SSH_KEY_ID.equals((sshKey = (BasicSSHUserPrivateKey)cred).getId())) continue;
                key = sshKey;
                break;
            }
            if (key != null) {
                store.removeCredentials(UserSSHKeyManager.getDomain(store), key);
                store.save();
            }
        }
        catch (IOException ex) {
            throw new ServiceException.UnexpectedErrorException("Unable to reset the user's key", (Throwable)ex);
        }
    }

    @CheckForNull
    private static CredentialsStore getUserStore(User user) {
        for (CredentialsStore s : CredentialsProvider.lookupStores((ModelObject)user)) {
            if (!s.hasPermission(CredentialsProvider.CREATE) || !s.hasPermission(CredentialsProvider.UPDATE)) continue;
            return s;
        }
        return null;
    }

    private static String getSSHPublicKey(RSAPublicKey key, User user) throws IOException {
        return "ssh-rsa " + Base64.encode((byte[])SSHKeyUtils.encodePublicKey(key)) + " " + UserSSHKeyManager.getKeyComment(user.getId());
    }

    private static String getKeyComment(String userId) {
        String host = Jenkins.getInstance().getRootUrl();
        if (host == null) {
            host = Jenkins.getInstance().getRootUrlFromRequest();
        }
        host = host.replaceAll(".*//([^/]+).*", "$1");
        return ((userId == null ? Jenkins.getInstance().getDisplayName() : userId) + "@" + host).replaceAll("[^:@._a-zA-Z0-9]", "");
    }

    private static Domain getDomain(CredentialsStore store) {
        Domain domain = store.getDomainByName(BLUEOCEAN_DOMAIN_NAME);
        if (domain == null) {
            try {
                boolean result = store.addDomain(new Domain(BLUEOCEAN_DOMAIN_NAME, null, null), new Credentials[0]);
                if (!result) {
                    throw new ServiceException.UnexpectedErrorException(String.format("Failed to create credential domain: %s", BLUEOCEAN_DOMAIN_NAME));
                }
                domain = store.getDomainByName(BLUEOCEAN_DOMAIN_NAME);
                if (domain == null) {
                    throw new ServiceException.UnexpectedErrorException(String.format("Domain %s created but not found", BLUEOCEAN_DOMAIN_NAME));
                }
            }
            catch (IOException ex) {
                throw new ServiceException.UnexpectedErrorException("Failed to save the Blue Ocean domain.", (Throwable)ex);
            }
        }
        return domain;
    }
}

