/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.service.embedded.rest;

import hudson.model.Item;
import hudson.model.Queue;
import io.jenkins.blueocean.commons.ServiceException;
import io.jenkins.blueocean.rest.factory.organization.OrganizationFactory;
import io.jenkins.blueocean.rest.hal.Link;
import io.jenkins.blueocean.rest.hal.Links;
import io.jenkins.blueocean.rest.model.BluePipeline;
import io.jenkins.blueocean.rest.model.BlueQueueItem;
import io.jenkins.blueocean.rest.model.BlueRun;
import io.jenkins.blueocean.service.embedded.rest.AbstractRunImpl;
import io.jenkins.blueocean.service.embedded.rest.QueuedBlueRun;
import java.util.Collection;
import java.util.Date;
import jenkins.model.Jenkins;

public class QueueItemImpl
extends BlueQueueItem {
    private final Queue.Item item;
    private final String pipelineName;
    private final Link self;
    private final Link parent;
    private final int expectedBuildNumber;

    public QueueItemImpl(Queue.Item item, BluePipeline pipeline, int expectedBuildNumber) {
        this(item, pipeline.getName(), expectedBuildNumber, pipeline.getQueue().getLink().rel(Long.toString(item.getId())), pipeline.getLink());
    }

    QueueItemImpl(Queue.Item item, String name, int expectedBuildNumber, Link self, Link parent) {
        this.item = item;
        this.pipelineName = name;
        this.expectedBuildNumber = expectedBuildNumber;
        this.self = self;
        this.parent = parent;
    }

    public String getId() {
        return Long.toString(this.item.getId());
    }

    public String getOrganization() {
        if (this.item.task instanceof Item) {
            Item i = (Item)this.item.task;
            return OrganizationFactory.getInstance().getContainingOrg(i).getName();
        }
        return null;
    }

    public String getPipeline() {
        return this.pipelineName;
    }

    public Date getQueuedTime() {
        return new Date(this.item.getInQueueSince());
    }

    public int getExpectedBuildNumber() {
        return this.expectedBuildNumber;
    }

    public void delete() {
        if (!this.item.hasCancelPermission()) {
            throw new ServiceException.ForbiddenException(String.format("Not authorized to stop queue: %s", this.getId()));
        }
        Jenkins.getInstance().getQueue().cancel(this.item);
    }

    public Collection<BlueRun.BlueCause> getCauses() {
        return AbstractRunImpl.BlueCauseImpl.getCauses(this.item.getCauses());
    }

    public String getCauseOfBlockage() {
        return this.item.getCauseOfBlockage().toString();
    }

    public BlueRun toRun() {
        return new QueuedBlueRun(BlueRun.BlueRunState.QUEUED, BlueRun.BlueRunResult.UNKNOWN, this, this.parent);
    }

    public Link getLink() {
        return this.self;
    }

    public Links getLinks() {
        return super.getLinks().add("parent", this.parent);
    }
}

