/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.service.embedded.rest;

import hudson.scm.ChangeLogSet;
import hudson.scm.RepositoryBrowser;
import io.jenkins.blueocean.rest.Reachable;
import io.jenkins.blueocean.rest.hal.Link;
import io.jenkins.blueocean.rest.model.BlueChangeSetEntry;
import io.jenkins.blueocean.rest.model.BlueUser;
import io.jenkins.blueocean.service.embedded.rest.UserImpl;
import java.io.IOException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Collection;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean
public class ChangeSetResource
extends BlueChangeSetEntry {
    private final ChangeLogSet.Entry changeSet;
    private final Reachable parent;

    public ChangeSetResource(ChangeLogSet.Entry changeSet, Reachable parent) {
        this.changeSet = changeSet;
        this.parent = parent;
    }

    public BlueUser getAuthor() {
        return new UserImpl(this.changeSet.getAuthor());
    }

    public String getTimestamp() {
        if (this.changeSet.getTimestamp() > 0L) {
            return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ").format(this.changeSet.getTimestamp());
        }
        return null;
    }

    public String getUrl() {
        RepositoryBrowser browser = this.changeSet.getParent().getBrowser();
        if (browser != null) {
            try {
                URL url = browser.getChangeSetLink(this.changeSet);
                return url == null ? null : url.toExternalForm();
            }
            catch (IOException e) {
                return null;
            }
        }
        return null;
    }

    public String getCommitId() {
        return this.changeSet.getCommitId();
    }

    public String getMsg() {
        return this.changeSet.getMsg();
    }

    public Collection<String> getAffectedPaths() {
        return this.changeSet.getAffectedPaths();
    }

    public Link getLink() {
        return this.parent.getLink().rel("changeset/" + this.getCommitId());
    }
}

