/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.service.embedded.rest;

import hudson.model.Run;
import io.jenkins.blueocean.rest.Reachable;
import io.jenkins.blueocean.rest.hal.Link;
import io.jenkins.blueocean.rest.model.BlueArtifact;

public class ArtifactImpl
extends BlueArtifact {
    private final Run run;
    private final Run.Artifact artifact;
    private final Link self;

    public ArtifactImpl(Run run, Run.Artifact artifact, Reachable parent) {
        this.run = run;
        this.artifact = artifact;
        this.self = parent.getLink().rel(this.getPath());
    }

    public String getName() {
        return this.artifact.getFileName();
    }

    public String getPath() {
        return this.artifact.relativePath;
    }

    public String getUrl() {
        return "/" + this.run.getUrl() + "artifact/" + this.artifact.getHref();
    }

    public long getSize() {
        try {
            return this.artifact.getFileSize();
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    public Link getLink() {
        return this.self;
    }
}

