/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.rest.impl.pipeline.scm;

import com.google.common.collect.ImmutableMap;
import hudson.model.User;
import io.jenkins.blueocean.commons.JsonConverter;
import io.jenkins.blueocean.commons.ServiceException;
import io.jenkins.blueocean.rest.impl.pipeline.scm.Scm;
import java.io.IOException;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.servlet.ServletException;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public abstract class AbstractScm
extends Scm {
    protected User getAuthenticatedUser() {
        User authenticatedUser = User.current();
        if (authenticatedUser == null) {
            throw new ServiceException.UnauthorizedException("No logged in user found");
        }
        return authenticatedUser;
    }

    protected HttpResponse createResponse(final String credentialId) {
        return new HttpResponse(){

            public void generateResponse(StaplerRequest req, StaplerResponse rsp, Object node) throws IOException, ServletException {
                rsp.setStatus(200);
                rsp.getWriter().print(JsonConverter.toJson((Object)ImmutableMap.of((Object)"credentialId", (Object)credentialId)));
            }
        };
    }

    @CheckForNull
    protected static String getCredentialIdFromRequest(@Nonnull StaplerRequest request) {
        String credentialId = request.getParameter("credentialId");
        if (credentialId == null) {
            credentialId = request.getHeader("X-CREDENTIAL-NAME");
        }
        return credentialId;
    }
}

