/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.preload;

import hudson.Extension;
import hudson.model.Item;
import io.jenkins.blueocean.commons.stapler.Export;
import io.jenkins.blueocean.preload.BlueUrlTokenizer;
import io.jenkins.blueocean.preload.RESTFetchPreloader;
import io.jenkins.blueocean.rest.factory.BluePipelineFactory;
import io.jenkins.blueocean.rest.model.BluePipeline;
import io.jenkins.blueocean.rest.model.BlueRunContainer;
import io.jenkins.blueocean.rest.model.Resource;
import java.io.IOException;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

@Extension
public class PipelineActivityStatePreloader
extends RESTFetchPreloader {
    private static final Logger LOGGER = Logger.getLogger(PipelineActivityStatePreloader.class.getName());
    private static final int DEFAULT_LIMIT = 26;

    @Override
    protected RESTFetchPreloader.FetchData getFetchData(@Nonnull BlueUrlTokenizer blueUrl) {
        BluePipeline pipeline = this.getPipeline(blueUrl);
        if (pipeline != null) {
            BlueRunContainer activitiesContainer = pipeline.getRuns();
            if (activitiesContainer == null) {
                return null;
            }
            Iterator activitiesIterator = activitiesContainer.iterator(0, 26);
            JSONArray activities = new JSONArray();
            while (activitiesIterator.hasNext()) {
                Resource blueActivity = (Resource)activitiesIterator.next();
                try {
                    activities.add((Object)JSONObject.fromObject((Object)Export.toJson((Object)blueActivity)));
                }
                catch (IOException e) {
                    LOGGER.log(Level.FINE, String.format("Unable to preload runs for Job '%s'. Activity serialization error.", pipeline.getFullName()), e);
                    return null;
                }
            }
            return new RESTFetchPreloader.FetchData(activitiesContainer.getLink().getHref() + "?start=0&limit=" + 26, activities.toString());
        }
        return null;
    }

    private BluePipeline getPipeline(BlueUrlTokenizer blueUrl) {
        if (this.addPipelineRuns(blueUrl)) {
            Jenkins jenkins = Jenkins.getInstance();
            String pipelineFullName = blueUrl.getPart(BlueUrlTokenizer.UrlPart.PIPELINE);
            try {
                Item pipelineJob = jenkins.getItemByFullName(pipelineFullName);
                return (BluePipeline)BluePipelineFactory.resolve((Item)pipelineJob);
            }
            catch (Exception e) {
                LOGGER.log(Level.FINE, String.format("Unable to find Job named '%s'.", pipelineFullName), e);
                return null;
            }
        }
        return null;
    }

    private boolean addPipelineRuns(@Nonnull BlueUrlTokenizer blueUrl) {
        if (blueUrl.lastPartIs(BlueUrlTokenizer.UrlPart.PIPELINE)) {
            return true;
        }
        return blueUrl.lastPartIs(BlueUrlTokenizer.UrlPart.PIPELINE_TAB, "activity");
    }
}

