/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.rest.impl.pipeline;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Queue;
import io.jenkins.blueocean.commons.ServiceException;
import io.jenkins.blueocean.rest.Navigable;
import io.jenkins.blueocean.rest.Reachable;
import io.jenkins.blueocean.rest.annotation.Capability;
import io.jenkins.blueocean.rest.factory.BluePipelineFactory;
import io.jenkins.blueocean.rest.hal.Link;
import io.jenkins.blueocean.rest.impl.pipeline.MultiBranchPipelineContainerImpl;
import io.jenkins.blueocean.rest.impl.pipeline.OrganizationFolderRunContainerImpl;
import io.jenkins.blueocean.rest.impl.pipeline.ScmResourceImpl;
import io.jenkins.blueocean.rest.impl.pipeline.scm.ScmSourceImpl;
import io.jenkins.blueocean.rest.model.BlueActionProxy;
import io.jenkins.blueocean.rest.model.BlueFavorite;
import io.jenkins.blueocean.rest.model.BlueFavoriteAction;
import io.jenkins.blueocean.rest.model.BlueIcon;
import io.jenkins.blueocean.rest.model.BlueOrganization;
import io.jenkins.blueocean.rest.model.BlueOrganizationFolder;
import io.jenkins.blueocean.rest.model.BluePipeline;
import io.jenkins.blueocean.rest.model.BluePipelineContainer;
import io.jenkins.blueocean.rest.model.BluePipelineScm;
import io.jenkins.blueocean.rest.model.BlueQueueContainer;
import io.jenkins.blueocean.rest.model.BlueQueueItem;
import io.jenkins.blueocean.rest.model.BlueRun;
import io.jenkins.blueocean.rest.model.BlueRunContainer;
import io.jenkins.blueocean.rest.model.BlueScmSource;
import io.jenkins.blueocean.rest.model.BlueTrendContainer;
import io.jenkins.blueocean.rest.model.Resource;
import io.jenkins.blueocean.service.embedded.rest.PipelineFolderImpl;
import io.jenkins.blueocean.service.embedded.rest.QueueItemImpl;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import jenkins.branch.OrganizationFolder;
import jenkins.model.Jenkins;
import jenkins.scm.api.metadata.AvatarMetadataAction;
import org.jenkinsci.plugins.workflow.multibranch.WorkflowMultiBranchProject;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.json.JsonBody;

@Capability(value={"jenkins.branch.OrganizationFolder", "io.jenkins.blueocean.rest.model.BluePipelineScm"})
public abstract class OrganizationFolderPipelineImpl
extends BlueOrganizationFolder {
    final OrganizationFolder folder;
    private final PipelineFolderImpl pipelineFolder;
    private final BlueOrganization organization;

    public OrganizationFolderPipelineImpl(BlueOrganization organization, OrganizationFolder folder, Link parent) {
        this.organization = organization;
        this.folder = folder;
        this.pipelineFolder = new PipelineFolderImpl(organization, (ItemGroup)folder, parent);
    }

    public BlueIcon getIcon() {
        AvatarMetadataAction action = (AvatarMetadataAction)this.folder.getAction(AvatarMetadataAction.class);
        return action != null ? new OrganizationIcon(action, this.getLink()) : null;
    }

    @Navigable
    public BluePipelineContainer getPipelines() {
        return new MultiBranchPipelineContainerImpl(this.organization, this.folder, (Reachable)this);
    }

    public Integer getNumberOfFolders() {
        return this.pipelineFolder.getNumberOfFolders();
    }

    public Integer getNumberOfPipelines() {
        return this.pipelineFolder.getNumberOfPipelines();
    }

    @Navigable
    public BlueRunContainer getRuns() {
        return new OrganizationFolderRunContainerImpl(this, (Reachable)this);
    }

    public Collection<BlueActionProxy> getActions() {
        return this.pipelineFolder.getActions();
    }

    public String getOrganizationName() {
        return this.organization.getName();
    }

    @Nonnull
    public BlueOrganization getOrganization() {
        return this.organization;
    }

    public String getName() {
        return this.pipelineFolder.getName();
    }

    public String getDisplayName() {
        return this.pipelineFolder.getDisplayName();
    }

    public String getFullName() {
        return this.pipelineFolder.getFullName();
    }

    public String getFullDisplayName() {
        return this.pipelineFolder.getFullDisplayName();
    }

    @Exported(inline=true)
    public BlueRun getLatestRun() {
        return new OrganizationFolderRunContainerImpl(this, (Reachable)this).get("1");
    }

    public Iterable<String> getPipelineFolderNames() {
        return Iterables.transform((Iterable)this.folder.getItems(), (Function)new Function<Item, String>(){

            public String apply(@Nullable Item input) {
                if (input instanceof WorkflowMultiBranchProject) {
                    return input.getName();
                }
                return null;
            }
        });
    }

    public Link getLink() {
        return this.pipelineFolder.getLink();
    }

    public boolean isScanAllRepos() {
        return true;
    }

    public BlueScmSource getScmSource() {
        return new ScmSourceImpl((Item)this.folder);
    }

    public BlueQueueContainer getQueue() {
        return new BlueQueueContainer(){

            public BlueQueueItem get(String name) {
                for (Queue.Item item : Jenkins.getInstance().getQueue().getItems((Queue.Task)OrganizationFolderPipelineImpl.this.folder)) {
                    if (item.getId() != Long.parseLong(name)) continue;
                    return new QueueItemImpl(OrganizationFolderPipelineImpl.this.organization, item, (BluePipeline)OrganizationFolderPipelineImpl.this, 1);
                }
                return null;
            }

            public Link getLink() {
                return OrganizationFolderPipelineImpl.this.getLink().rel("queue");
            }

            public Iterator<BlueQueueItem> iterator() {
                return new Iterator<BlueQueueItem>(){
                    Iterator<Queue.Item> it;
                    {
                        this.it = Jenkins.getInstance().getQueue().getItems((Queue.Task)OrganizationFolderPipelineImpl.this.folder).iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.it.hasNext();
                    }

                    @Override
                    public BlueQueueItem next() {
                        return new QueueItemImpl(OrganizationFolderPipelineImpl.this.organization, this.it.next(), (BluePipeline)OrganizationFolderPipelineImpl.this, 1);
                    }

                    @Override
                    public void remove() {
                    }
                };
            }
        };
    }

    public List<Object> getParameters() {
        return null;
    }

    public BlueFavorite favorite(@JsonBody BlueFavoriteAction favoriteAction) {
        return null;
    }

    public Map<String, Boolean> getPermissions() {
        return null;
    }

    public BluePipelineScm getScm() {
        return new ScmResourceImpl((Item)this.folder, (Reachable)this);
    }

    protected OrganizationFolder getFolder() {
        return this.folder;
    }

    public BlueTrendContainer getTrends() {
        return null;
    }

    public static class OrganizationIcon
    extends BlueIcon {
        private final AvatarMetadataAction action;
        private final Link parent;

        public OrganizationIcon(AvatarMetadataAction action, Link parent) {
            this.action = action;
            this.parent = parent;
        }

        public void getUrl() {
            StaplerRequest req = Stapler.getCurrentRequest();
            String s = req.getParameter("s");
            if (s == null) {
                s = Integer.toString(20);
            }
            StaplerResponse resp = Stapler.getCurrentResponse();
            try {
                resp.setHeader("Cache-Control", "max-age=" + TimeUnit.DAYS.toDays(7L));
                resp.sendRedirect(this.action.getAvatarImageOf(s));
            }
            catch (IOException e) {
                throw new ServiceException.UnexpectedErrorException("Could not provide icon", (Throwable)e);
            }
        }

        public Link getLink() {
            return this.parent.rel("icon");
        }
    }

    public static abstract class OrganizationFolderFactory
    extends BluePipelineFactory {
        protected abstract OrganizationFolderPipelineImpl getFolder(OrganizationFolder var1, Reachable var2, BlueOrganization var3);

        public OrganizationFolderPipelineImpl getPipeline(Item item, Reachable parent, BlueOrganization organization) {
            if (item instanceof OrganizationFolder) {
                return this.getFolder((OrganizationFolder)item, parent, organization);
            }
            return null;
        }

        public Resource resolve(Item context, Reachable parent, Item target, BlueOrganization organization) {
            OrganizationFolderPipelineImpl folder = this.getPipeline(context, parent, organization);
            if (folder != null) {
                if (context == target) {
                    return folder;
                }
                Item nextChild = OrganizationFolderFactory.findNextStep((ItemGroup)folder.folder, (Item)target);
                for (BluePipelineFactory f : OrganizationFolderFactory.all()) {
                    Resource answer = f.resolve(nextChild, (Reachable)folder, target, organization);
                    if (answer == null) continue;
                    return answer;
                }
            }
            return null;
        }
    }
}

