/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.rest.impl.pipeline;

import io.jenkins.blueocean.listeners.NodeDownstreamBuildAction;
import io.jenkins.blueocean.rest.Reachable;
import io.jenkins.blueocean.rest.hal.Link;
import io.jenkins.blueocean.rest.impl.pipeline.FlowNodeWrapper;
import io.jenkins.blueocean.rest.impl.pipeline.NodeLogResource;
import io.jenkins.blueocean.rest.impl.pipeline.NodeRunStatus;
import io.jenkins.blueocean.rest.impl.pipeline.PipelineNodeUtil;
import io.jenkins.blueocean.rest.impl.pipeline.PipelineStepContainerImpl;
import io.jenkins.blueocean.rest.model.BlueActionProxy;
import io.jenkins.blueocean.rest.model.BlueInputStep;
import io.jenkins.blueocean.rest.model.BluePipelineNode;
import io.jenkins.blueocean.rest.model.BluePipelineStepContainer;
import io.jenkins.blueocean.rest.model.BlueRun;
import io.jenkins.blueocean.service.embedded.rest.AbstractRunImpl;
import io.jenkins.blueocean.service.embedded.rest.ActionProxiesImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.jenkinsci.plugins.workflow.actions.LogAction;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.export.Exported;

public class PipelineNodeImpl
extends BluePipelineNode {
    private final FlowNodeWrapper node;
    private final List<BluePipelineNode.Edge> edges;
    private final Long durationInMillis;
    private final NodeRunStatus status;
    private final Link self;
    private final WorkflowRun run;
    private final Reachable parent;

    public PipelineNodeImpl(FlowNodeWrapper node, Reachable parent, WorkflowRun run) {
        this.node = node;
        this.run = run;
        this.edges = this.buildEdges(node.edges);
        this.status = node.getStatus();
        this.durationInMillis = node.getTiming().getTotalDurationMillis();
        this.self = parent.getLink().rel(node.getId());
        this.parent = parent;
    }

    public String getId() {
        return this.node.getId();
    }

    public String getDisplayName() {
        return PipelineNodeUtil.getDisplayName(this.node.getNode());
    }

    public String getDisplayDescription() {
        return null;
    }

    public BlueRun.BlueRunResult getResult() {
        return this.status.getResult();
    }

    public BlueRun.BlueRunState getStateObj() {
        return this.status.getState();
    }

    public Date getStartTime() {
        long nodeTime = this.node.getTiming().getStartTimeMillis();
        if (nodeTime == 0L) {
            return null;
        }
        return new Date(nodeTime);
    }

    public String getStartTimeString() {
        if (this.getStartTime() == null) {
            return null;
        }
        return AbstractRunImpl.DATE_FORMAT.print(this.getStartTime().getTime());
    }

    public List<BluePipelineNode.Edge> getEdges() {
        return this.edges;
    }

    public Long getDurationInMillis() {
        return this.durationInMillis;
    }

    public Object getLog() {
        return new NodeLogResource(this);
    }

    public String getType() {
        return this.node.getType().name();
    }

    public String getStepType() {
        throw new UnsupportedOperationException("not supported");
    }

    public String getCauseOfBlockage() {
        return this.node.getCauseOfFailure();
    }

    public BluePipelineStepContainer getSteps() {
        return new PipelineStepContainerImpl(this.node, this.self, this.run);
    }

    public Link getLink() {
        return this.self;
    }

    public Collection<BlueActionProxy> getActions() {
        HashSet<NodeDownstreamBuildAction> actions = new HashSet<NodeDownstreamBuildAction>();
        actions.addAll(this.node.getNode().getActions());
        actions.addAll(this.node.getPipelineActions(NodeDownstreamBuildAction.class));
        return ActionProxiesImpl.getActionProxies(actions, input -> input instanceof LogAction || input instanceof NodeDownstreamBuildAction, (Reachable)this);
    }

    public BlueInputStep getInputStep() {
        return null;
    }

    public HttpResponse submitInputStep(StaplerRequest request) {
        return null;
    }

    private List<BluePipelineNode.Edge> buildEdges(List<FlowNodeWrapper> nodes) {
        ArrayList<BluePipelineNode.Edge> edges = new ArrayList<BluePipelineNode.Edge>();
        if (!nodes.isEmpty()) {
            for (FlowNodeWrapper edge : nodes) {
                edges.add(new EdgeImpl(edge));
            }
        }
        return edges;
    }

    FlowNodeWrapper getFlowNodeWrapper() {
        return this.node;
    }

    public static class EdgeImpl
    extends BluePipelineNode.Edge {
        private final String id;
        private final String type;

        public EdgeImpl(FlowNodeWrapper edge) {
            this.id = edge.getId();
            this.type = edge.getType().name();
        }

        public String getId() {
            return this.id;
        }

        @Exported
        public String getType() {
            return this.type;
        }
    }
}

