/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.rest.impl.pipeline;

import com.cloudbees.hudson.plugins.folder.AbstractFolder;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import hudson.Extension;
import hudson.model.AbstractItem;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.Result;
import hudson.model.Run;
import io.jenkins.blueocean.commons.ServiceException;
import io.jenkins.blueocean.rest.Navigable;
import io.jenkins.blueocean.rest.Reachable;
import io.jenkins.blueocean.rest.annotation.Capability;
import io.jenkins.blueocean.rest.factory.BlueFavoriteResolver;
import io.jenkins.blueocean.rest.factory.BluePipelineFactory;
import io.jenkins.blueocean.rest.hal.Link;
import io.jenkins.blueocean.rest.hal.LinkResolver;
import io.jenkins.blueocean.rest.impl.pipeline.BranchContainerImpl;
import io.jenkins.blueocean.rest.impl.pipeline.BranchImpl;
import io.jenkins.blueocean.rest.impl.pipeline.MultiBranchPipelineQueueContainer;
import io.jenkins.blueocean.rest.impl.pipeline.MultibranchPipelineRunContainer;
import io.jenkins.blueocean.rest.impl.pipeline.PipelineImpl;
import io.jenkins.blueocean.rest.impl.pipeline.PipelineJobFilters;
import io.jenkins.blueocean.rest.impl.pipeline.PrimaryBranch;
import io.jenkins.blueocean.rest.impl.pipeline.ScmResourceImpl;
import io.jenkins.blueocean.rest.impl.pipeline.scm.ScmSourceImpl;
import io.jenkins.blueocean.rest.model.BlueActionProxy;
import io.jenkins.blueocean.rest.model.BlueFavorite;
import io.jenkins.blueocean.rest.model.BlueFavoriteAction;
import io.jenkins.blueocean.rest.model.BlueIcon;
import io.jenkins.blueocean.rest.model.BlueMultiBranchPipeline;
import io.jenkins.blueocean.rest.model.BlueOrganization;
import io.jenkins.blueocean.rest.model.BluePipeline;
import io.jenkins.blueocean.rest.model.BluePipelineContainer;
import io.jenkins.blueocean.rest.model.BluePipelineScm;
import io.jenkins.blueocean.rest.model.BlueQueueContainer;
import io.jenkins.blueocean.rest.model.BlueRun;
import io.jenkins.blueocean.rest.model.BlueRunContainer;
import io.jenkins.blueocean.rest.model.BlueScmSource;
import io.jenkins.blueocean.rest.model.Resource;
import io.jenkins.blueocean.service.embedded.rest.AbstractPipelineImpl;
import io.jenkins.blueocean.service.embedded.rest.ActionProxiesImpl;
import io.jenkins.blueocean.service.embedded.rest.FavoriteImpl;
import io.jenkins.blueocean.service.embedded.util.FavoriteUtil;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import jenkins.branch.MultiBranchProject;
import org.kohsuke.stapler.json.JsonBody;

@Capability(value={"jenkins.branch.MultiBranchProject", "io.jenkins.blueocean.rest.model.BluePipelineScm"})
public class MultiBranchPipelineImpl
extends BlueMultiBranchPipeline {
    final MultiBranchProject mbp;
    private final Link self;
    private final BlueOrganization organization;

    public MultiBranchPipelineImpl(BlueOrganization organization, MultiBranchProject mbp) {
        this.mbp = mbp;
        this.organization = organization;
        this.self = this.organization.getLink().rel("pipelines").rel(PipelineImpl.getRecursivePathFromFullName((BluePipeline)this));
    }

    @Nonnull
    public BlueOrganization getOrganization() {
        return this.organization;
    }

    public String getOrganizationName() {
        return this.organization.getName();
    }

    public BlueFavorite favorite(@JsonBody BlueFavoriteAction favoriteAction) {
        if (favoriteAction == null) {
            throw new ServiceException.BadRequestException("Must provide pipeline name");
        }
        Job job = PrimaryBranch.resolve((AbstractFolder)this.mbp);
        if (job == null) {
            throw new ServiceException.BadRequestException("no default branch to favorite");
        }
        FavoriteUtil.toggle((BlueFavoriteAction)favoriteAction, (Item)job);
        return new FavoriteImpl((Object)new BranchImpl(this.organization, job, this.getLink().rel("branches")), this.getLink().rel("favorite"));
    }

    public Map<String, Boolean> getPermissions() {
        return AbstractPipelineImpl.getPermissions((AbstractItem)this.mbp);
    }

    @Navigable
    public BluePipelineScm getScm() {
        return new ScmResourceImpl((Item)this.mbp, (Reachable)this);
    }

    public String getName() {
        return this.mbp.getName();
    }

    public String getDisplayName() {
        return this.mbp.getDisplayName();
    }

    public String getFullName() {
        return AbstractPipelineImpl.getFullName((BlueOrganization)this.organization, (Item)this.mbp);
    }

    public String getFullDisplayName() {
        return AbstractPipelineImpl.getFullDisplayName((BlueOrganization)this.organization, (Item)this.mbp);
    }

    public int getTotalNumberOfBranches() {
        return this.countJobs(false);
    }

    public int getNumberOfFailingBranches() {
        return this.countRunStatus(Result.FAILURE, false);
    }

    public int getNumberOfSuccessfulBranches() {
        return this.countRunStatus(Result.SUCCESS, false);
    }

    public int getTotalNumberOfPullRequests() {
        return this.countJobs(true);
    }

    public int getNumberOfFailingPullRequests() {
        return this.countRunStatus(Result.FAILURE, true);
    }

    public int getNumberOfSuccessfulPullRequests() {
        return this.countRunStatus(Result.SUCCESS, true);
    }

    public BluePipelineContainer getPipelines() {
        return new BranchContainerImpl(this, this.getLink().rel("pipelines"));
    }

    public Integer getNumberOfFolders() {
        return 0;
    }

    public Integer getNumberOfPipelines() {
        return this.getTotalNumberOfBranches();
    }

    public Integer getWeatherScore() {
        Job j = PrimaryBranch.resolve((AbstractFolder)this.mbp);
        return j == null ? 100 : j.getBuildHealth().getScore();
    }

    public BlueRun getLatestRun() {
        return null;
    }

    public Long getEstimatedDurationInMillis() {
        return this.mbp.getEstimatedDuration();
    }

    @Navigable
    public BluePipelineContainer getBranches() {
        return new BranchContainerImpl(this, this.getLink().rel("branches"));
    }

    public Collection<String> getBranchNames() {
        return Collections2.transform((Collection)ImmutableList.copyOf((Iterator)this.getBranches().iterator()), (Function)new Function<BluePipeline, String>(){

            public String apply(BluePipeline input) {
                return input.getName();
            }
        });
    }

    private int countRunStatus(Result result, boolean pullRequests) {
        Collection jobs = this.mbp.getAllJobs();
        int count = 0;
        for (Job j : jobs) {
            if ((!pullRequests || !PipelineJobFilters.isPullRequest((Item)j)) && (pullRequests || PipelineJobFilters.isPullRequest((Item)j))) continue;
            j.getBuildStatusUrl();
            Run run = j.getLastBuild();
            if (run == null || run.getResult() != result) continue;
            ++count;
        }
        return count;
    }

    private int countJobs(boolean pullRequests) {
        Collection jobs = this.mbp.getAllJobs();
        int counter = 0;
        for (Job job : jobs) {
            if ((!pullRequests || !PipelineJobFilters.isPullRequest((Item)job)) && (pullRequests || PipelineJobFilters.isPullRequest((Item)job))) continue;
            ++counter;
        }
        return counter;
    }

    public BlueRunContainer getRuns() {
        return new MultibranchPipelineRunContainer(this);
    }

    public Collection<BlueActionProxy> getActions() {
        return ActionProxiesImpl.getActionProxies((List)this.mbp.getAllActions(), (Reachable)this);
    }

    public BlueQueueContainer getQueue() {
        return new MultiBranchPipelineQueueContainer(this);
    }

    public Link getLink() {
        return this.self;
    }

    public List<Object> getParameters() {
        return null;
    }

    public BlueIcon getIcon() {
        return null;
    }

    public BlueScmSource getScmSource() {
        return new ScmSourceImpl((Item)this.mbp);
    }

    @Extension(ordinal=1.0)
    public static class FavoriteResolverImpl
    extends BlueFavoriteResolver {
        public BlueFavorite resolve(Item item, Reachable parent) {
            MultiBranchProject project;
            Job job;
            if (item instanceof MultiBranchProject && (job = PrimaryBranch.resolve((AbstractFolder)(project = (MultiBranchProject)item))) != null) {
                Resource resource = BluePipelineFactory.resolve((Item)job);
                Link l = LinkResolver.resolveLink((Object)project);
                if (l != null) {
                    return new FavoriteImpl((Object)resource, l.rel("favorite"));
                }
            }
            return null;
        }
    }

    @Extension(ordinal=2.0)
    public static class PipelineFactoryImpl
    extends BluePipelineFactory {
        public MultiBranchPipelineImpl getPipeline(Item item, Reachable parent, BlueOrganization organization) {
            if (item instanceof MultiBranchProject) {
                return new MultiBranchPipelineImpl(organization, (MultiBranchProject)item);
            }
            return null;
        }

        public Resource resolve(Item context, Reachable parent, Item target, BlueOrganization organization) {
            if (context instanceof MultiBranchProject) {
                if (context == target) {
                    return this.getPipeline(context, parent, organization);
                }
                if (context == target.getParent()) {
                    return (Resource)this.getPipeline(context, parent, organization).getBranches().get(target.getName());
                }
            }
            return null;
        }
    }
}

