/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.rest.impl.pipeline;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.jenkins.blueocean.rest.Reachable;
import io.jenkins.blueocean.rest.hal.Link;
import io.jenkins.blueocean.rest.impl.pipeline.MultiBranchPipelineImpl;
import io.jenkins.blueocean.rest.model.BlueMultiBranchPipeline;
import io.jenkins.blueocean.rest.model.BlueOrganization;
import io.jenkins.blueocean.rest.model.BluePipeline;
import io.jenkins.blueocean.rest.model.BluePipelineContainer;
import java.util.ArrayList;
import java.util.Iterator;
import jenkins.branch.MultiBranchProject;
import jenkins.branch.OrganizationFolder;

public class MultiBranchPipelineContainerImpl
extends BluePipelineContainer {
    private final OrganizationFolder folder;
    private final Link self;

    public MultiBranchPipelineContainerImpl(BlueOrganization organization, OrganizationFolder folder, Reachable parent) {
        super(organization);
        this.folder = folder;
        this.self = parent.getLink();
    }

    public BlueMultiBranchPipeline get(String s) {
        MultiBranchProject mbp = this.folder.getItem(s);
        if (mbp == null) {
            return null;
        }
        return new MultiBranchPipelineImpl(this.organization, mbp);
    }

    public Link getLink() {
        return this.self;
    }

    @NonNull
    public Iterator<BluePipeline> iterator() {
        ArrayList<MultiBranchPipelineImpl> pipelines = new ArrayList<MultiBranchPipelineImpl>();
        for (MultiBranchProject mbp : this.folder.getItems()) {
            pipelines.add(new MultiBranchPipelineImpl(this.organization, mbp));
        }
        return pipelines.iterator();
    }
}

