/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.rest.impl.pipeline;

import com.cloudbees.hudson.plugins.folder.computed.FolderComputation;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.Action;
import hudson.model.Cause;
import hudson.model.CauseAction;
import hudson.model.Result;
import io.jenkins.blueocean.rest.Reachable;
import io.jenkins.blueocean.rest.hal.Link;
import io.jenkins.blueocean.rest.impl.pipeline.OrganizationFolderPipelineImpl;
import io.jenkins.blueocean.rest.model.BlueActionProxy;
import io.jenkins.blueocean.rest.model.BlueArtifactContainer;
import io.jenkins.blueocean.rest.model.BlueChangeSetEntry;
import io.jenkins.blueocean.rest.model.BluePipeline;
import io.jenkins.blueocean.rest.model.BluePipelineNodeContainer;
import io.jenkins.blueocean.rest.model.BluePipelineStepContainer;
import io.jenkins.blueocean.rest.model.BlueRun;
import io.jenkins.blueocean.rest.model.BlueTestResultContainer;
import io.jenkins.blueocean.rest.model.BlueTestSummary;
import io.jenkins.blueocean.rest.model.Container;
import io.jenkins.blueocean.rest.model.Containers;
import io.jenkins.blueocean.service.embedded.rest.LogResource;
import io.jenkins.blueocean.service.embedded.rest.QueueItemImpl;
import java.util.Collection;
import java.util.Date;
import org.kohsuke.stapler.QueryParameter;

public class OrganizationFolderRunImpl
extends BlueRun {
    static final String RUN_ID = "1";
    private final OrganizationFolderPipelineImpl pipeline;
    private final Link self;
    private final FolderComputation folderComputation;

    public OrganizationFolderRunImpl(OrganizationFolderPipelineImpl pipeline, Reachable parent) {
        this.pipeline = pipeline;
        this.folderComputation = pipeline.folder.getComputation();
        this.self = parent.getLink().rel(RUN_ID);
    }

    public Link getLink() {
        return this.self;
    }

    public String getOrganization() {
        return this.pipeline.getOrganizationName();
    }

    public String getId() {
        return RUN_ID;
    }

    public String getPipeline() {
        return this.pipeline.getName();
    }

    public String getName() {
        return null;
    }

    public String getDescription() {
        return null;
    }

    public Date getStartTime() {
        return this.folderComputation.getTimestamp().getTime();
    }

    @NonNull
    public Container<BlueChangeSetEntry> getChangeSet() {
        return Containers.empty((Link)this.getLink());
    }

    public Date getEnQueueTime() {
        return this.getStartTime();
    }

    public Date getEndTime() {
        return null;
    }

    public String getStartTimeString() {
        return null;
    }

    public String getEnQueueTimeString() {
        return null;
    }

    public String getEndTimeString() {
        return null;
    }

    public Long getDurationInMillis() {
        if (this.folderComputation.isBuilding()) {
            return System.currentTimeMillis() - this.folderComputation.getTimestamp().getTimeInMillis();
        }
        return this.getEstimatedDurtionInMillis();
    }

    public Long getEstimatedDurtionInMillis() {
        return this.folderComputation.getEstimatedDuration();
    }

    public BlueRun.BlueRunState getStateObj() {
        return this.folderComputation.isBuilding() ? BlueRun.BlueRunState.RUNNING : BlueRun.BlueRunState.FINISHED;
    }

    public BlueRun.BlueRunResult getResult() {
        Result result = this.folderComputation.getResult();
        return result != null ? BlueRun.BlueRunResult.valueOf((String)result.toString()) : BlueRun.BlueRunResult.UNKNOWN;
    }

    public String getRunSummary() {
        return String.format("%s:%s", this.getResult(), this.getStateObj());
    }

    public String getType() {
        return FolderComputation.class.getName();
    }

    public BlueRun stop(@QueryParameter(value="blocking") Boolean blocking, @QueryParameter(value="timeOutInSecs") Integer timeOutInSecs) {
        return null;
    }

    public String getArtifactsZipFile() {
        return null;
    }

    public BlueArtifactContainer getArtifacts() {
        return null;
    }

    public BluePipelineNodeContainer getNodes() {
        return null;
    }

    public Collection<BlueActionProxy> getActions() {
        return null;
    }

    public BluePipelineStepContainer getSteps() {
        return null;
    }

    public BlueTestResultContainer getTests() {
        return null;
    }

    public BlueTestSummary getTestSummary() {
        return null;
    }

    public BlueTestSummary getBlueTestSummary() {
        return null;
    }

    public Object getLog() {
        return new LogResource(this.folderComputation.getLogText());
    }

    public Collection<BlueRun.BlueCause> getCauses() {
        return null;
    }

    public String getCauseOfBlockage() {
        return null;
    }

    public BlueRun replay() {
        if (this.isReplayable()) {
            return new QueueItemImpl(this.pipeline.getOrganization(), this.pipeline.folder.scheduleBuild2(0, new Action[]{new CauseAction((Cause)new Cause.UserIdCause())}), (BluePipeline)this.pipeline, 1).toRun();
        }
        return null;
    }

    public boolean isReplayable() {
        return this.pipeline.folder.isBuildable();
    }
}

