/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.rest.impl.pipeline;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import hudson.Extension;
import hudson.model.Job;
import hudson.model.Queue;
import hudson.model.Run;
import hudson.model.queue.CauseOfBlockage;
import io.jenkins.blueocean.commons.ServiceException;
import io.jenkins.blueocean.rest.Navigable;
import io.jenkins.blueocean.rest.Reachable;
import io.jenkins.blueocean.rest.annotation.Capability;
import io.jenkins.blueocean.rest.factory.BlueRunFactory;
import io.jenkins.blueocean.rest.impl.pipeline.BranchImpl;
import io.jenkins.blueocean.rest.impl.pipeline.PipelineNodeContainerImpl;
import io.jenkins.blueocean.rest.impl.pipeline.PipelineStepContainerImpl;
import io.jenkins.blueocean.rest.model.BlueChangeSetEntry;
import io.jenkins.blueocean.rest.model.BlueOrganization;
import io.jenkins.blueocean.rest.model.BluePipelineNode;
import io.jenkins.blueocean.rest.model.BluePipelineNodeContainer;
import io.jenkins.blueocean.rest.model.BluePipelineStepContainer;
import io.jenkins.blueocean.rest.model.BlueQueueItem;
import io.jenkins.blueocean.rest.model.BlueRun;
import io.jenkins.blueocean.rest.model.Container;
import io.jenkins.blueocean.service.embedded.rest.AbstractRunImpl;
import io.jenkins.blueocean.service.embedded.rest.QueueUtil;
import java.util.Comparator;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import jenkins.model.Jenkins;
import jenkins.scm.api.SCMRevisionAction;
import org.jenkinsci.plugins.workflow.cps.replay.ReplayAction;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.jenkinsci.plugins.workflow.support.steps.ExecutorStepExecution;
import org.jenkinsci.plugins.workflow.support.steps.input.InputAction;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.export.Exported;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Capability(value={"org.jenkinsci.plugins.workflow.job.WorkflowRun"})
public class PipelineRunImpl
extends AbstractRunImpl<WorkflowRun> {
    private static final Logger logger = LoggerFactory.getLogger(PipelineRunImpl.class);
    private BluePipelineNodeContainer bluePipelineNodeContainer;
    static final long PIPELINE_NODE_CONTAINER_CACHE_MAX_SIZE = Long.getLong("PIPELINE_NODE_CONTAINER_CACHE_MAX_SIZE", 10000L);
    static final int PIPELINE_NODE_CONTAINER_CACHE_HOURS = Integer.getInteger("PIPELINE_NODE_CONTAINER_CACHE_HOURS", 12);
    private static Cache<String, PipelineNodeContainerImpl> PIPELINE_NODE_CONTAINER_LOADING_CACHE = Caffeine.newBuilder().maximumSize(PIPELINE_NODE_CONTAINER_CACHE_MAX_SIZE).expireAfterAccess((long)PIPELINE_NODE_CONTAINER_CACHE_HOURS, TimeUnit.HOURS).build();
    public static final Comparator<BlueRun> LATEST_RUN_START_TIME_COMPARATOR = (o1, o2) -> {
        Long t1 = o1 != null && o1.getStartTime() != null ? o1.getStartTime().getTime() : 0L;
        Long t2 = o2 != null && o2.getStartTime() != null ? o2.getStartTime().getTime() : 0L;
        return t2.compareTo(t1);
    };

    public PipelineRunImpl(WorkflowRun run, Reachable parent, BlueOrganization organization) {
        super((Run)run, parent, organization);
    }

    @Exported(name="branch", inline=true)
    public BranchImpl.Branch getBranch() {
        return BranchImpl.Branch.getBranch(((WorkflowRun)this.run).getParent());
    }

    @Exported(name="pullRequest", inline=true)
    public BranchImpl.PullRequest getPullRequest() {
        return BranchImpl.PullRequest.get(((WorkflowRun)this.run).getParent());
    }

    public BlueRun.BlueRunState getStateObj() {
        InputAction inputAction = (InputAction)((WorkflowRun)this.run).getAction(InputAction.class);
        try {
            if (inputAction != null && inputAction.getExecutions().size() > 0) {
                return BlueRun.BlueRunState.PAUSED;
            }
        }
        catch (InterruptedException | TimeoutException e) {
            logger.error("Error getting StateObject from execution context: " + e.getMessage(), (Throwable)e);
        }
        boolean isQueued = false;
        boolean isRunning = false;
        String causeOfBlockage = this.getCauseOfBlockage();
        for (BluePipelineNode n : this.getNodes()) {
            BlueRun.BlueRunState nodeState = n.getStateObj();
            if (nodeState == null) {
                if (causeOfBlockage != null) {
                    isQueued = true;
                    continue;
                }
                isRunning = true;
                continue;
            }
            if (nodeState.equals((Object)BlueRun.BlueRunState.QUEUED)) {
                isQueued = true;
                continue;
            }
            if (!nodeState.equals((Object)BlueRun.BlueRunState.RUNNING)) continue;
            isRunning = true;
        }
        if (!isRunning && (isQueued || causeOfBlockage != null)) {
            return BlueRun.BlueRunState.QUEUED;
        }
        return super.getStateObj();
    }

    public BlueRun replay() {
        ReplayAction replayAction = (ReplayAction)((WorkflowRun)this.run).getAction(ReplayAction.class);
        if (!this.isReplayable(replayAction)) {
            throw new ServiceException.BadRequestException("This run does not support replay");
        }
        Queue.Item item = replayAction.run2(replayAction.getOriginalScript(), replayAction.getOriginalLoadedScripts());
        if (item == null) {
            throw new ServiceException.UnexpectedErrorException("Run was not added to queue.");
        }
        BlueQueueItem queueItem = QueueUtil.getQueuedItem((BlueOrganization)this.organization, (Queue.Item)item, (Job)((WorkflowRun)this.run).getParent());
        WorkflowRun replayedRun = (WorkflowRun)QueueUtil.getRun((Job)((WorkflowRun)this.run).getParent(), (long)item.getId());
        if (queueItem != null) {
            return queueItem.toRun();
        }
        if (replayedRun != null) {
            return new PipelineRunImpl(replayedRun, this.parent, this.organization);
        }
        throw new ServiceException.UnexpectedErrorException("Run was not added to queue.");
    }

    public boolean isReplayable() {
        ReplayAction replayAction = (ReplayAction)((WorkflowRun)this.run).getAction(ReplayAction.class);
        return this.isReplayable(replayAction);
    }

    private boolean isReplayable(ReplayAction replayAction) {
        return replayAction != null && replayAction.isRebuildEnabled();
    }

    static void clearCache() {
        PIPELINE_NODE_CONTAINER_LOADING_CACHE.invalidateAll();
    }

    static WorkflowRun findRun(String externalizableId) {
        Run run = Run.fromExternalizableId((String)externalizableId);
        if (run == null) {
            throw new NullPointerException("not run found for id `" + externalizableId + "` this should not happen here.");
        }
        if (!(run instanceof WorkflowRun)) {
            throw new NullPointerException("run with id `" + externalizableId + "` cannot be an instance of WorkflowRun.");
        }
        return (WorkflowRun)run;
    }

    @Navigable
    public BluePipelineNodeContainer getNodes() {
        if (this.run != null) {
            if (!((WorkflowRun)this.run).isLogUpdated()) {
                this.bluePipelineNodeContainer = (BluePipelineNodeContainer)PIPELINE_NODE_CONTAINER_LOADING_CACHE.get((Object)this.getLink().getHref(), s -> new PipelineNodeContainerImpl((WorkflowRun)this.run, this.getLink()));
            }
            if (this.bluePipelineNodeContainer == null) {
                this.bluePipelineNodeContainer = new PipelineNodeContainerImpl((WorkflowRun)this.run, this.getLink());
            }
            return this.bluePipelineNodeContainer;
        }
        return null;
    }

    @Navigable
    public BluePipelineStepContainer getSteps() {
        return new PipelineStepContainerImpl(((WorkflowRun)this.run).getExternalizableId(), this.getLink());
    }

    public BlueRun stop(@QueryParameter(value="blocking") Boolean blocking, @QueryParameter(value="timeOutInSecs") Integer timeOutInSecs) {
        return this.stop(blocking, timeOutInSecs, () -> ((WorkflowRun)((WorkflowRun)this.run)).doStop());
    }

    @Exported(name="commitId")
    public String getCommitId() {
        SCMRevisionAction data = (SCMRevisionAction)((WorkflowRun)this.run).getAction(SCMRevisionAction.class);
        if (data != null) {
            return data.getRevision().toString();
        }
        return null;
    }

    @Exported(name="commitUrl")
    public String getCommitUrl() {
        Container changeSets;
        BlueChangeSetEntry entry;
        String commitId = this.getCommitId();
        if (commitId != null && (entry = (BlueChangeSetEntry)(changeSets = this.getChangeSet()).get(commitId)) != null) {
            return entry.getUrl();
        }
        return null;
    }

    public String getCauseOfBlockage() {
        for (Queue.Item i : Jenkins.get().getQueue().getItems()) {
            ExecutorStepExecution.PlaceholderTask task;
            Run r;
            if (!(i.task instanceof ExecutorStepExecution.PlaceholderTask) || (r = (task = (ExecutorStepExecution.PlaceholderTask)i.task).runForDisplay()) == null || !r.equals(this.run)) continue;
            String cause = i.getCauseOfBlockage().getShortDescription();
            CauseOfBlockage causeOfBlockage = task.getCauseOfBlockage();
            if (causeOfBlockage != null) {
                return causeOfBlockage.getShortDescription();
            }
            return cause;
        }
        return null;
    }

    @Extension(ordinal=1.0)
    public static class FactoryImpl
    extends BlueRunFactory {
        public BlueRun getRun(Run run, Reachable parent, BlueOrganization organization) {
            if (run instanceof WorkflowRun) {
                return new PipelineRunImpl((WorkflowRun)run, parent, organization);
            }
            return null;
        }
    }
}

