/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.rest.impl.pipeline.analytics;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.model.listeners.RunListener;
import io.jenkins.blueocean.analytics.Analytics;
import io.jenkins.blueocean.rest.hal.Link;
import io.jenkins.blueocean.rest.impl.pipeline.NodeGraphBuilder;
import io.jenkins.blueocean.service.embedded.analytics.Tally;
import java.util.HashMap;
import org.jenkinsci.plugins.pipeline.modeldefinition.actions.DeclarativeJobAction;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Extension
@Restricted(value={NoExternalUse.class})
public class PipelinePluginAnalytics
extends RunListener<WorkflowRun> {
    public void onCompleted(WorkflowRun workflowRun, @NonNull TaskListener listener) {
        Analytics analytics = Analytics.get();
        if (analytics == null) {
            return;
        }
        Tally tally = new Tally();
        NodeGraphBuilder builder = NodeGraphBuilder.NodeGraphBuilderFactory.getInstance(workflowRun);
        builder.getPipelineNodeSteps(new Link("steps/")).forEach(step -> tally.count(step.getStepType()));
        boolean isDeclarative = ((WorkflowJob)workflowRun.getParent()).getAction(DeclarativeJobAction.class) != null;
        Result result = workflowRun.getResult();
        String resultAsString = result != null ? result.toString() : "UNKNOWN";
        tally.get().forEach((key, value) -> {
            HashMap<String, Object> props = new HashMap<String, Object>();
            props.put("type", key);
            props.put("timesUsed", value);
            props.put("isDeclarative", isDeclarative);
            props.put("runResult", resultAsString);
            analytics.track(new Analytics.TrackRequest("pipeline_step_used", props));
        });
    }
}

