/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.rest.impl.pipeline.scm;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.ExtensionList;
import hudson.ExtensionPoint;
import io.jenkins.blueocean.rest.Reachable;
import io.jenkins.blueocean.rest.impl.pipeline.scm.Scm;
import java.util.List;
import java.util.stream.Collectors;

public abstract class ScmFactory
implements ExtensionPoint {
    @CheckForNull
    public abstract Scm getScm(@NonNull String var1, @NonNull Reachable var2);

    @NonNull
    public abstract Scm getScm(Reachable var1);

    @CheckForNull
    public static Scm resolve(@NonNull String id, @NonNull Reachable parent) {
        for (ScmFactory scmFactory : ScmFactory.all()) {
            Scm scm = scmFactory.getScm(id, parent);
            if (scm == null) continue;
            return scm;
        }
        return null;
    }

    @NonNull
    public static List<Scm> resolve(@NonNull Reachable parent) {
        return ScmFactory.all().stream().map(scmFactory -> scmFactory.getScm(parent)).collect(Collectors.toList());
    }

    public static ExtensionList<ScmFactory> all() {
        return ExtensionList.lookup(ScmFactory.class);
    }
}

