/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.rest.impl.pipeline.analytics;

import hudson.Extension;
import hudson.model.Item;
import io.jenkins.blueocean.service.embedded.analytics.JobAnalyticsCheck;
import io.jenkins.blueocean.service.embedded.analytics.JobAnalyticsExclude;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Extension
@Restricted(value={NoExternalUse.class})
public final class MavenAnalyticsCheck
implements JobAnalyticsCheck {
    public static final String MAVEN_MODULE_SET_CLASS = "hudson.maven.MavenModuleSet";

    public String getName() {
        return "maven";
    }

    public Boolean apply(Item item) {
        return item.getClass().getName().equals(MAVEN_MODULE_SET_CLASS);
    }

    @Extension
    @Restricted(value={NoExternalUse.class})
    public static final class ExcludeImpl
    implements JobAnalyticsExclude {
        public Boolean apply(Item item) {
            return item.getClass().getName().equals("hudson.maven.MavenModule") || item.getParent().getClass().getName().equals(MavenAnalyticsCheck.MAVEN_MODULE_SET_CLASS);
        }
    }
}

