/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.rest.impl.pipeline.scm;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.Item;
import hudson.model.User;
import hudson.security.AccessControlled;
import io.jenkins.blueocean.commons.JsonConverter;
import io.jenkins.blueocean.commons.ListsUtils;
import io.jenkins.blueocean.commons.MapsHelper;
import io.jenkins.blueocean.commons.ServiceException;
import io.jenkins.blueocean.rest.factory.organization.AbstractOrganization;
import io.jenkins.blueocean.rest.factory.organization.OrganizationFactory;
import io.jenkins.blueocean.rest.impl.pipeline.scm.Scm;
import io.jenkins.blueocean.rest.model.BlueOrganization;
import java.util.Collection;
import jenkins.model.ModifiableTopLevelItemGroup;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.StaplerRequest;

public abstract class AbstractScm
extends Scm {
    protected User getAuthenticatedUser() {
        User authenticatedUser = User.current();
        if (authenticatedUser == null) {
            throw new ServiceException.UnauthorizedException("No logged in user found");
        }
        return authenticatedUser;
    }

    protected HttpResponse createResponse(String credentialId) {
        return (req, rsp, node) -> {
            rsp.setStatus(200);
            rsp.getWriter().print(JsonConverter.toJson((Object)MapsHelper.of((Object)"credentialId", (Object)credentialId)));
        };
    }

    @CheckForNull
    protected static String getCredentialIdFromRequest(@NonNull StaplerRequest request) {
        String credentialId = request.getParameter("credentialId");
        if (credentialId == null) {
            credentialId = request.getHeader("X-CREDENTIAL-NAME");
        }
        return credentialId;
    }

    protected static AccessControlled getRootOrgFolder() {
        BlueOrganization organization = (BlueOrganization)ListsUtils.getFirst((Collection)OrganizationFactory.getInstance().list(), null);
        if (organization instanceof AbstractOrganization) {
            ModifiableTopLevelItemGroup group = ((AbstractOrganization)organization).getGroup();
            return (AccessControlled)group;
        }
        throw new AssertionError((Object)(organization + " is not an instance of AbstractOrganization"));
    }

    protected void checkPermission() {
        AccessControlled rootOrgFolder = AbstractScm.getRootOrgFolder();
        if (!rootOrgFolder.hasPermission(Item.CREATE)) {
            throw new ServiceException.ForbiddenException("You do not have Job/Create permission");
        }
    }
}

