/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.rest.impl.pipeline;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.ExtensionList;
import hudson.FilePath;
import hudson.console.AnnotatedLargeText;
import hudson.model.Failure;
import hudson.model.FileParameterValue;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import io.jenkins.blueocean.commons.JSON;
import io.jenkins.blueocean.commons.ServiceException;
import io.jenkins.blueocean.rest.Reachable;
import io.jenkins.blueocean.rest.hal.Link;
import io.jenkins.blueocean.rest.impl.pipeline.FlowNodeWrapper;
import io.jenkins.blueocean.rest.impl.pipeline.InputStepImpl;
import io.jenkins.blueocean.rest.impl.pipeline.PipelineInputStepListener;
import io.jenkins.blueocean.rest.model.BlueActionProxy;
import io.jenkins.blueocean.rest.model.BlueInputStep;
import io.jenkins.blueocean.rest.model.BluePipelineStep;
import io.jenkins.blueocean.rest.model.BlueRun;
import io.jenkins.blueocean.service.embedded.rest.AbstractRunImpl;
import io.jenkins.blueocean.service.embedded.rest.ActionProxiesImpl;
import io.jenkins.blueocean.service.embedded.rest.LogAppender;
import io.jenkins.blueocean.service.embedded.rest.LogResource;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.concurrent.TimeoutException;
import jenkins.model.Jenkins;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.io.IOUtils;
import org.jenkinsci.plugins.workflow.actions.ArgumentsAction;
import org.jenkinsci.plugins.workflow.actions.LogAction;
import org.jenkinsci.plugins.workflow.cps.nodes.StepEndNode;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.graph.StepNode;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.support.steps.input.InputAction;
import org.jenkinsci.plugins.workflow.support.steps.input.InputStep;
import org.jenkinsci.plugins.workflow.support.steps.input.InputStepExecution;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.framework.io.ByteBuffer;
import org.springframework.security.core.Authentication;

public class PipelineStepImpl
extends BluePipelineStep {
    private final FlowNodeWrapper node;
    private final Link self;
    public static final String PARAMETERS_ELEMENT = "parameters";
    public static final String ID_ELEMENT = "id";
    public static final String ABORT_ELEMENT = "abort";
    public static final String NAME_ELEMENT = "name";

    public PipelineStepImpl(FlowNodeWrapper node, Link parent) {
        assert (node != null);
        this.self = parent.rel(node.getId());
        this.node = node;
    }

    public String getId() {
        return this.node.getId();
    }

    public String getDisplayName() {
        return this.node.getNode().getDisplayName();
    }

    public String getDisplayDescription() {
        String displayDescription = ArgumentsAction.getStepArgumentsAsString((FlowNode)this.node.getNode());
        if (displayDescription != null) {
            displayDescription = JSON.sanitizeString((String)displayDescription);
        }
        return displayDescription;
    }

    public String getType() {
        return this.node.getType().name();
    }

    public String getStepType() {
        StepNode stepNode;
        StepDescriptor descriptor;
        FlowNode flowNode = this.node.getNode();
        if (flowNode instanceof StepNode && !(flowNode instanceof StepEndNode) && (descriptor = (stepNode = (StepNode)flowNode).getDescriptor()) != null) {
            return descriptor.getId();
        }
        return "unknown";
    }

    public BlueRun.BlueRunResult getResult() {
        return this.node.getStatus().getResult();
    }

    public BlueRun.BlueRunState getStateObj() {
        return this.node.getStatus().getState();
    }

    public Date getStartTime() {
        return new Date(this.node.getTiming().getStartTimeMillis());
    }

    public Long getDurationInMillis() {
        return this.node.getTiming().getTotalDurationMillis();
    }

    public String getStartTimeString() {
        return AbstractRunImpl.DATE_FORMAT.format(this.getStartTime().toInstant());
    }

    public Object getLog() {
        LogAction logAction = (LogAction)this.node.getNode().getAction(LogAction.class);
        if (logAction != null) {
            final String errorLog = this.node.blockError();
            if (errorLog != null) {
                return new LogResource(logAction.getLogText(), new LogAppender(){

                    @NonNull
                    public Reader getLog() {
                        return new StringReader(errorLog + "\n");
                    }
                });
            }
            return new LogResource(logAction.getLogText());
        }
        return PipelineStepImpl.getLogResource(this.node);
    }

    FlowNodeWrapper getFlowNodeWrapper() {
        return this.node;
    }

    private static LogResource getLogResource(FlowNodeWrapper node) {
        LogResource logResource;
        String msg = node.nodeError();
        if (msg == null) {
            msg = node.blockError();
        }
        if (msg == null) {
            return null;
        }
        msg = msg + "\n";
        ByteBuffer byteBuffer = new ByteBuffer();
        try {
            byteBuffer.write(msg.getBytes(StandardCharsets.UTF_8));
            logResource = new LogResource(new AnnotatedLargeText(byteBuffer, StandardCharsets.UTF_8, true, null));
        }
        catch (Throwable throwable) {
            try {
                try {
                    byteBuffer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new ServiceException.UnexpectedErrorException(e.getMessage());
            }
        }
        byteBuffer.close();
        return logResource;
    }

    public Collection<BlueActionProxy> getActions() {
        return ActionProxiesImpl.getActionProxies((Collection)this.node.getNode().getActions(), input -> input instanceof LogAction, (Reachable)this);
    }

    public BlueInputStep getInputStep() {
        InputStep inputStep = this.node.getInputStep();
        if (inputStep != null) {
            return new InputStepImpl(inputStep, (Reachable)this);
        }
        return null;
    }

    public HttpResponse submitInputStep(StaplerRequest request) {
        JSONObject body;
        try {
            body = JSONObject.fromObject((Object)IOUtils.toString((Reader)request.getReader()));
        }
        catch (IOException e) {
            throw new ServiceException.UnexpectedErrorException(e.getMessage());
        }
        String id = body.getString(ID_ELEMENT);
        if (id == null) {
            throw new ServiceException.BadRequestException("id is required");
        }
        if (body.get(PARAMETERS_ELEMENT) == null && body.get(ABORT_ELEMENT) == null) {
            throw new ServiceException.BadRequestException("parameters is required");
        }
        WorkflowRun run = this.node.getRun();
        InputAction inputAction = (InputAction)run.getAction(InputAction.class);
        if (inputAction == null) {
            throw new ServiceException.BadRequestException("Error processing Input Submit request. This Run instance does not have an InputAction.");
        }
        try {
            InputStepExecution execution = inputAction.getExecution(id);
            if (execution == null) {
                throw new ServiceException.BadRequestException(String.format("Error processing Input Submit request. This Run instance does not have an Input with an id of '%s'.", id));
            }
            if (body.get(ABORT_ELEMENT) != null && body.getBoolean(ABORT_ELEMENT)) {
                return execution.doAbort();
            }
            try {
                execution.preSubmissionCheck();
            }
            catch (Failure f) {
                throw new ServiceException.BadRequestException(f.getMessage());
            }
            Object o = this.parseValue(execution, JSONArray.fromObject((Object)body.get(PARAMETERS_ELEMENT)), request);
            HttpResponse response = execution.proceed(o);
            for (PipelineInputStepListener listener : ExtensionList.lookup(PipelineInputStepListener.class)) {
                listener.onStepContinue(execution.getInput(), run);
            }
            return response;
        }
        catch (IOException | InterruptedException | TimeoutException e) {
            throw new ServiceException.UnexpectedErrorException("Error processing Input Submit request." + e.getMessage());
        }
    }

    private Object parseValue(InputStepExecution execution, JSONArray parameters, StaplerRequest request) throws IOException, InterruptedException {
        HashMap<String, Object> mapResult = new HashMap<String, Object>();
        InputStep input = execution.getInput();
        for (Object o : parameters) {
            JSONObject p = (JSONObject)o;
            String name = (String)p.get(NAME_ELEMENT);
            if (name == null) {
                throw new ServiceException.BadRequestException("name is required parameter element");
            }
            ParameterDefinition d = null;
            for (ParameterDefinition def : input.getParameters()) {
                if (!def.getName().equals(name)) continue;
                d = def;
            }
            if (d == null) {
                throw new ServiceException.BadRequestException("No such parameter definition: " + name);
            }
            ParameterValue v = d.createValue(request, p);
            if (v == null) continue;
            mapResult.put(name, this.convert(name, v));
        }
        String valueName = input.getSubmitterParameter();
        if (valueName != null && !valueName.isEmpty()) {
            Authentication a = Jenkins.getAuthentication2();
            mapResult.put(valueName, a.getName());
        }
        switch (mapResult.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return mapResult.values().iterator().next();
            }
        }
        return mapResult;
    }

    private Object convert(String name, ParameterValue v) throws IOException, InterruptedException {
        if (v instanceof FileParameterValue) {
            FileParameterValue fv = (FileParameterValue)v;
            FilePath fp = new FilePath(this.node.getRun().getRootDir()).child(name);
            fp.copyFrom(fv.getFile());
            return fp;
        }
        return v.getValue();
    }

    public Link getLink() {
        return this.self;
    }
}

