/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.rest.impl.pipeline;

import hudson.model.Action;
import hudson.model.Cause;
import hudson.model.CauseAction;
import hudson.model.Item;
import hudson.model.Queue;
import io.jenkins.blueocean.commons.ServiceException;
import io.jenkins.blueocean.rest.Utils;
import io.jenkins.blueocean.rest.hal.Link;
import io.jenkins.blueocean.rest.impl.pipeline.MultiBranchPipelineImpl;
import io.jenkins.blueocean.rest.impl.pipeline.PipelineRunImpl;
import io.jenkins.blueocean.rest.model.BluePipeline;
import io.jenkins.blueocean.rest.model.BlueRun;
import io.jenkins.blueocean.rest.model.BlueRunContainer;
import io.jenkins.blueocean.service.embedded.rest.QueueItemImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;

public class MultibranchPipelineRunContainer
extends BlueRunContainer {
    private static final int MAX_MBP_RUNS_ROWS = Integer.getInteger("MAX_MBP_RUNS_ROWS", 250);
    private final MultiBranchPipelineImpl blueMbPipeline;
    private final Link self;

    public MultibranchPipelineRunContainer(MultiBranchPipelineImpl pipeline) {
        this.blueMbPipeline = pipeline;
        this.self = pipeline.getLink().rel("runs");
    }

    public Link getLink() {
        return this.self;
    }

    public BlueRun get(String name) {
        return null;
    }

    public Iterator<BlueRun> iterator() {
        throw new ServiceException.NotImplementedException("Not implemented");
    }

    public Iterator<BlueRun> iterator(int start, int limit) {
        List<Object> branches;
        ArrayList<BlueRun> c = new ArrayList<BlueRun>();
        StaplerRequest req = Stapler.getCurrentRequest();
        String branchFilter = null;
        if (req != null) {
            branchFilter = req.getParameter("branch");
        }
        if (!StringUtils.isEmpty(branchFilter)) {
            BluePipeline pipeline = (BluePipeline)this.blueMbPipeline.getBranches().get(branchFilter);
            branches = pipeline != null ? Collections.singletonList(pipeline) : Collections.emptyList();
        } else {
            branches = StreamSupport.stream(this.blueMbPipeline.getBranches().spliterator(), false).collect(Collectors.toList());
            MultibranchPipelineRunContainer.sortBranchesByLatestRun(branches);
        }
        for (BluePipeline b : branches) {
            BlueRunContainer blueRunContainer = b.getRuns();
            if (blueRunContainer == null) continue;
            Iterator it = blueRunContainer.iterator(0, MAX_MBP_RUNS_ROWS);
            int count = 0;
            Utils.skip((Iterator)it, (int)start);
            while (it.hasNext() && count++ < limit) {
                c.add((BlueRun)it.next());
            }
        }
        c.sort(PipelineRunImpl.LATEST_RUN_START_TIME_COMPARATOR);
        return c.stream().limit(limit).iterator();
    }

    static void sortBranchesByLatestRun(List<BluePipeline> branches) {
        branches.sort((o1, o2) -> PipelineRunImpl.LATEST_RUN_START_TIME_COMPARATOR.compare(o1.getLatestRun(), o2.getLatestRun()));
    }

    public BlueRun create(StaplerRequest request) {
        this.blueMbPipeline.mbp.checkPermission(Item.BUILD);
        Queue.Item queueItem = this.blueMbPipeline.mbp.scheduleBuild2(0, new Action[]{new CauseAction((Cause)new Cause.UserIdCause())});
        if (queueItem == null) {
            return null;
        }
        return new QueueItemImpl(this.blueMbPipeline.getOrganization(), queueItem, (BluePipeline)this.blueMbPipeline, 1).toRun();
    }
}

