/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.rest.impl.pipeline.scm;

import hudson.model.User;
import io.jenkins.blueocean.commons.JsonConverter;
import io.jenkins.blueocean.commons.MapsHelper;
import io.jenkins.blueocean.commons.ServiceException;
import io.jenkins.blueocean.rest.impl.pipeline.scm.Scm;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.StaplerRequest;

public abstract class AbstractScm
extends Scm {
    protected User getAuthenticatedUser() {
        User authenticatedUser = User.current();
        if (authenticatedUser == null) {
            throw new ServiceException.UnauthorizedException("No logged in user found");
        }
        return authenticatedUser;
    }

    protected HttpResponse createResponse(String credentialId) {
        return (req, rsp, node) -> {
            rsp.setStatus(200);
            rsp.getWriter().print(JsonConverter.toJson((Object)MapsHelper.of((Object)"credentialId", (Object)credentialId)));
        };
    }

    @CheckForNull
    protected static String getCredentialIdFromRequest(@Nonnull StaplerRequest request) {
        String credentialId = request.getParameter("credentialId");
        if (credentialId == null) {
            credentialId = request.getHeader("X-CREDENTIAL-NAME");
        }
        return credentialId;
    }
}

