/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.rest.impl.pipeline;

import com.cloudbees.hudson.plugins.folder.Folder;
import hudson.Extension;
import hudson.model.Item;
import io.jenkins.blueocean.service.embedded.rest.ContainerFilter;
import java.util.function.Predicate;
import jenkins.branch.OrganizationFolder;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.mixin.ChangeRequestSCMHead;

public class PipelineJobFilters {
    public static boolean isPullRequest(Item item) {
        return SCMHead.HeadByItem.findHead((Item)item) instanceof ChangeRequestSCMHead;
    }

    @Extension
    public static class PullRequestFilter
    extends ContainerFilter {
        private final Predicate<Item> filter = job -> PipelineJobFilters.isPullRequest(job);

        public String getName() {
            return "pull-requests";
        }

        public Predicate<Item> getFilter() {
            return this.filter;
        }
    }

    @Extension
    public static class OriginFilter
    extends ContainerFilter {
        private final Predicate<Item> filter = job -> !PipelineJobFilters.isPullRequest(job);

        public String getName() {
            return "origin";
        }

        public Predicate<Item> getFilter() {
            return this.filter;
        }
    }

    @Extension
    public static class FolderJobFilter
    extends ContainerFilter {
        private final Predicate<Item> filter = job -> !Folder.class.equals(job.getClass()) && !(job instanceof OrganizationFolder);

        public String getName() {
            return "no-folders";
        }

        public Predicate<Item> getFilter() {
            return this.filter;
        }
    }
}

