/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.rest.impl.pipeline;

import hudson.model.Item;
import hudson.model.Job;
import io.jenkins.blueocean.commons.ServiceException;
import io.jenkins.blueocean.rest.factory.organization.OrganizationFactory;
import io.jenkins.blueocean.rest.hal.Link;
import io.jenkins.blueocean.rest.impl.pipeline.BranchImpl;
import io.jenkins.blueocean.rest.impl.pipeline.MultiBranchPipelineImpl;
import io.jenkins.blueocean.rest.model.BlueOrganization;
import io.jenkins.blueocean.rest.model.BluePipeline;
import io.jenkins.blueocean.rest.model.BluePipelineContainer;
import io.jenkins.blueocean.rest.model.BlueRun;
import io.jenkins.blueocean.service.embedded.rest.ContainerFilter;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;

public class BranchContainerImpl
extends BluePipelineContainer {
    private static final Comparator<BluePipeline> BRANCH_COMPARATOR = new Comparator<BluePipeline>(){

        @Override
        public int compare(BluePipeline _pipeline1, BluePipeline _pipeline2) {
            BranchImpl pipeline1 = (BranchImpl)_pipeline1;
            BranchImpl pipeline2 = (BranchImpl)_pipeline2;
            BranchImpl.Branch branch1 = pipeline1.getBranch();
            if (branch1 == null) {
                return -1;
            }
            BranchImpl.Branch branch2 = pipeline2.getBranch();
            if (branch2 == null) {
                return 1;
            }
            if (branch1.isPrimary() && !branch2.isPrimary()) {
                return -1;
            }
            if (!branch1.isPrimary() && branch2.isPrimary()) {
                return 1;
            }
            if (pipeline1.isFavorite() && !pipeline2.isFavorite()) {
                return -1;
            }
            if (!pipeline1.isFavorite() && pipeline2.isFavorite()) {
                return 1;
            }
            BlueRun latestRun1 = pipeline1.getLatestRun();
            BlueRun latestRun2 = pipeline2.getLatestRun();
            if (latestRun1 != null && latestRun2 == null) {
                return -1;
            }
            if (latestRun1 == null && latestRun2 != null) {
                return 1;
            }
            if (latestRun1 == null) {
                return pipeline1.getName().compareTo(pipeline2.getName());
            }
            Date endTime1 = latestRun1.getEndTime();
            Date endTime2 = latestRun2.getEndTime();
            if (endTime1 != null && endTime2 == null) {
                return 1;
            }
            if (endTime1 == null && endTime2 != null) {
                return -1;
            }
            if (endTime1 != null) {
                if (endTime1.getTime() > endTime2.getTime()) {
                    return -1;
                }
                if (endTime1.getTime() < endTime2.getTime()) {
                    return 1;
                }
                return pipeline1.getName().compareTo(pipeline2.getName());
            }
            Date startTime1 = latestRun1.getStartTime();
            Date startTime2 = latestRun2.getStartTime();
            if (startTime1 != null && startTime2 == null) {
                return 1;
            }
            if (startTime1 == null && startTime2 != null) {
                return -1;
            }
            if (startTime1 != null && startTime2 != null) {
                if (startTime1.getTime() > startTime2.getTime()) {
                    return -1;
                }
                if (startTime1.getTime() < startTime2.getTime()) {
                    return 1;
                }
                return pipeline1.getName().compareTo(pipeline2.getName());
            }
            return pipeline1.getName().compareTo(pipeline2.getName());
        }
    };
    private final MultiBranchPipelineImpl pipeline;
    private final Link self;

    public BranchContainerImpl(MultiBranchPipelineImpl pipeline, Link self) {
        super(pipeline.getOrganization());
        this.pipeline = pipeline;
        this.self = self;
    }

    public BluePipeline get(String name) {
        Job job = this.pipeline.mbp.getItem(name);
        if (job == null) {
            return null;
        }
        BlueOrganization organization = OrganizationFactory.getInstance().getContainingOrg((Item)job);
        if (organization == null) {
            return null;
        }
        return new BranchImpl(organization, job, this.getLink());
    }

    public Iterator<BluePipeline> iterator() {
        return this.iterator(0, 100);
    }

    public Iterator<BluePipeline> iterator(int start, int limit) {
        BlueOrganization organization = OrganizationFactory.getInstance().getContainingOrg(this.pipeline.mbp.getItemGroup());
        if (organization == null) {
            throw new ServiceException.UnexpectedErrorException("Could not find organization for " + this.pipeline.mbp.getFullName());
        }
        Link link = this.getLink();
        Collection allJobsMatchinFilter = ContainerFilter.filter((Collection)this.pipeline.mbp.getAllJobs());
        return allJobsMatchinFilter.stream().map(job -> new BranchImpl(organization, (Job)job, link)).sorted(BRANCH_COMPARATOR).skip(start).limit(limit).iterator();
    }

    public Link getLink() {
        return this.self;
    }
}

